<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['dashboard']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content" id="app">
        <cmo_strategic></cmo_strategic>
    </div>
    <template id="cmo_strategic">
        <div>
            <?php hooks()->do_action('before_dashboards_content'); ?>
            <div class="row mb20">
                <div class="col-md-12">
                    <div class="" style="background: white;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12 bgbox">
                                        <div class="col-md-9">
                                            <select class="form-control" name="period_filter" id="period_filter"
                                                    v-model="period_filter" @change="filter_on_change($event)">
                                                <option value="30d"><?= _l('filter_period_last_30d'); ?></option>
                                                <option value="t"><?= _l('filter_period_today'); ?></option>
                                                <option value="y"><?= _l('filter_period_yesterday'); ?></option>
                                                <option value="w"><?= _l('filter_period_current_week'); ?></option>
                                                <option value="lw"><?= _l('filter_period_last_week'); ?></option>
                                                <option value="m"><?= _l('filter_period_current_month'); ?></option>
                                                <option value="lm"><?= _l('filter_period_last_month'); ?></option>
                                                <option value="yr"><?= _l('filter_period_current_year'); ?></option>
                                                <option value="lyr"><?= _l('filter_period_last_year'); ?></option>
                                                <option value="p"><?= _l('filter_period_range'); ?></option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <a href="#" class="btn btn-primary d-inline" @click.prevent="filter_on_change"><i
                                                        class="fa fa-refresh"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row" v-if=" period_filter == 'p' ">
                                    <div class="col-md-8">
                                        <vue-datepicker @selected-date="updated"></vue-datepicker>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="bgbox">
                                            <button class="btn btn-primary" @click="filter_on_change()"><?= _l('filter_apply'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row pl-5 pr-5">
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_leads') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="total_leads"></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_total_leads && globals.delta_total_leads > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_total_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_total_leads < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_total_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_total_leads == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_total_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>

                                <?php /*<span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="">5%</span> to target ($130,233)</p></span>*/ ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_iql') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="iql_leads"></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_iql_leads > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_iql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_iql_leads < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_iql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_iql_leads == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_iql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <?php /*<span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="">5%</span> to target ($130,233)</p></span>*/ ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_mql') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="mql_leads"></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_mql_leads > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_mql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_mql_leads < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_mql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_sql_leads == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_mql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <?php /*<span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="">5%</span> to target ($130,233)</p></span>*/ ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_sql') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="sql_leads"></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_sql_leads > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_sql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_sql_leads < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_sql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_sql_leads == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_sql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <?php /*<span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="">5%</span> to target ($130,233)</p></span>*/ ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row pl-5 pr-5">
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_clients') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="total_clients"></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_total_clients && globals.delta_total_clients > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_total_clients"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_total_clients < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_total_clients"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_total_clients == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_total_clients"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_contacts') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="total_contacts"></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_total_contacts && globals.delta_total_contacts > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_total_contacts"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_total_contacts < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_total_contacts"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_total_contacts == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_total_contacts"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_cost_per_lead') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title"><?= _l('title_total'); ?>:
                                    <span ref="cost_per_lead"></span></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_cost_per_lead && globals.delta_cost_per_lead > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_cost_per_lead"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_cost_per_lead < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_cost_per_lead"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_cost_per_lead == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_cost_per_lead"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                            </div>
                            <div class="dashcard__chart">
                                <div id="chart_cost_per_lead"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_cost_per_mql') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title"><?= _l('Total'); ?>:
                                    <span ref="cost_per_mql"></span></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_cost_per_mql && globals.delta_cost_per_mql > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_cost_per_mql"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_cost_per_mql < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_cost_per_mql"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_cost_per_mql == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_cost_per_mql"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                            </div>
                            <div class="dashcard__chart">
                                <div id="chart_cost_per_mql"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </template>

    <?php show_footer(); ?><?php init_tail(); ?>
    <div>
