<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['dashboard']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content" id="app">
        <inbound_lead_generation></inbound_lead_generation>
    </div>
    <template id="inbound_lead_generation">
        <div>
            <?php hooks()->do_action('before_dashboards_content'); ?>
            <div class="row mb20">
                <div class="col-md-12">
                    <div class="" style="background: white;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12 bgbox">
                                        <div class="col-md-9">
                                            <select class="form-control" name="period_filter" id="period_filter"
                                                    v-model="period_filter" @change="filter_on_change($event)">
                                                <option value="30d"><?= _l('filter_period_last_30d'); ?></option>
                                                <option value="t"><?= _l('filter_period_today'); ?></option>
                                                <option value="y"><?= _l('filter_period_yesterday'); ?></option>
                                                <option value="w"><?= _l('filter_period_current_week'); ?></option>
                                                <option value="lw"><?= _l('filter_period_last_week'); ?></option>
                                                <option value="m"><?= _l('filter_period_current_month'); ?></option>
                                                <option value="lm"><?= _l('filter_period_last_month'); ?></option>
                                                <option value="yr"><?= _l('filter_period_current_year'); ?></option>
                                                <option value="lyr"><?= _l('filter_period_last_year'); ?></option>
                                                <option value="p"><?= _l('filter_period_range'); ?></option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <a href="#" class="btn btn-primary d-inline" @click.prevent="filter_on_change"><i
                                                        class="fa fa-refresh"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row" v-if=" period_filter == 'p' ">
                                    <div class="col-md-8">
                                        <vue-datepicker @selected-date="updated"></vue-datepicker>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="bgbox">
                                            <button class="btn btn-primary" @click="filter_on_change()"><?= _l('filter_apply'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row pl-5 pr-50">
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_leads') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="total_leads"></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_total_leads && globals.delta_total_leads > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_total_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_total_leads < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_total_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_total_leads == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_total_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>

                                <?php /*<span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="">5%</span> to target ($130,233)</p></span>*/ ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_iql') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="iql_leads"></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_iql_leads > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_iql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_iql_leads < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_iql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_iql_leads == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_iql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <?php /*<span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="">5%</span> to target ($130,233)</p></span>*/ ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_mql') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="mql_leads"></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_mql_leads > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_mql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_mql_leads < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_mql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_sql_leads == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_mql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <?php /*<span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="">5%</span> to target ($130,233)</p></span>*/ ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('title_sql') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="sql_leads"></h4>
                                <span class="dashcard__widget1_figures" v-if="globals.delta_sql_leads > 0"><p class="mg-b-0 tx-sm"><span class="tx-success"><i class="fa fa-arrow-up"></i> <span ref="delta_sql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_sql_leads < 0"><p class="mg-b-0 tx-sm"><span class="tx-danger"><i class="fa fa-arrow-down"></i> <span ref="delta_sql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <span class="dashcard__widget1_figures" v-else-if="globals.delta_sql_leads == 0"><p class="mg-b-0 tx-sm"><span class="tx-muted"><span ref="delta_sql_leads"></span>%</span> <?= _l('versus_previous_period'); ?></p></span>
                                <?php /*<span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="">5%</span> to target ($130,233)</p></span>*/ ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row pl-5 pr-5">
                <div class="col-sm-6 col-lg-4 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title">
                                <?= _l('leads_by_source') ?>
                            </div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title"></h4></div>
                            <div class="dashcard__chart">
                                <div id="leads_by_source"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title">
                                <?= _l('leads_by_pipeline') ?>
                            </div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title"></h4></div>
                            <div class="dashcard__chart">
                                <div id="leads_by_pipeline"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title">
                                <?= _l('leads_by_form') ?>
                            </div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title"></h4></div>
                            <div class="dashcard__chart">
                                <div id="leads_by_form"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php /*
    <div class="row p-0 m-0">
      <div class="col-sm-12 col-md-4 p-10 m-0">
        <div class="dashcard">
          <div class="dashcard__header border">
            <div class="dashcard__header_title">
              <?= _l('Leads breakdown this month') ?>
            </div>
            <div class="dashcard__header_right_title"></div>
          </div>
          <div class="dashcard__body">
            <div class="dashcard__widget1">
              <h4 class="dashcard__widget1_title"></h4> </div>
            <div class="dashcard__chart">
              <div id="lead_breakdown_month"></div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-sm-12 col-md-8 p-10 m-0">
        <div class="dashcard">
          <div class="dashcard__header border">
            <div class="dashcard__header_title">
              <?= _l('traffic') ?>
            </div>
            <div class="dashcard__header_right_title"></div>
          </div>
          <div class="dashcard__body">
            <div class="dashcard__widget1">
              <h4 class="dashcard__widget1_title"></h4> </div>
            <div class="row">
              <div class="col-md-12 p-10">
                <?php
              $fields = ['Channel','Progress'];
              render_datatable($fields,'traffic'); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row p-0 m-0">
      <div class="col-sm-12 col-md-12 p-10 m-0">
        <div class="dashcard">
          <div class="dashcard__header border">
            <div class="dashcard__header_title">
              <?= _l('Key conversion metrics') ?>
            </div>
            <div class="dashcard__header_right_title"></div>
          </div>
          <div class="dashcard__body">
            <div class="row">
              <div class="col-lg-6 col-xs-12 col-md-12 total-column">
                <div class="panel_s">
                  <div class="panel-body">
                    <h3 class="text-muted _total"> 7.65%</h3> <span class="tx-good"><?= _l('web_to_lead'); ?></span> </div>
                </div>
              </div>
              <div class="col-lg-6 col-xs-12 col-md-12 total-column">
                <div class="panel_s">
                  <div class="panel-body">
                    <h3 class="text-muted _total"> 42.58%</h3> <span class="tx-good"><?= _l('lead_to_trial'); ?></span> </div>
                </div>
              </div>
              <div class="col-lg-6 col-xs-12 col-md-12 total-column">
                <div class="panel_s">
                  <div class="panel-body">
                    <h3 class="text-muted _total"> 9.34%</h3> <span class="tx-good"><?= _l('lead_to_customer'); ?></span> </div>
                </div>
              </div>
              <div class="col-lg-6 col-xs-12 col-md-12 total-column">
                <div class="panel_s">
                  <div class="panel-body">
                    <h3 class="text-muted _total"> 12.32%</h3> <span class="tx-good"><?= _l('lead_to_demo'); ?></span> </div>
                </div>
              </div>
              <div class="col-lg-6 col-xs-12 col-md-12 total-column">
                <div class="panel_s">
                  <div class="panel-body">
                    <h3 class="text-muted _total"> 11.32%</h3> <span class="tx-good"><?= _l('percent1'); ?></span> </div>
                </div>
              </div>
              <div class="col-lg-6 col-xs-12 col-md-12 total-column">
                <div class="panel_s">
                  <div class="panel-body">
                    <h3 class="text-muted _total"> 76.12%</h3> <span class="tx-good"><?= _l('lead_to_implementation'); ?></span> </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    */ ?>


        </div>
    </template>

    <?php show_footer(); ?><?php init_tail(); ?>
    <div>
