<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb col-md-12">
        <a href="<?php echo admin_url(); ?>"><?= _l('sales_conversion_dashboard') ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a
                href="<?php echo admin_url("okr/dashboard"); ?>"><?php echo _l('okr'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>

    <div class="admin-title">
        <h1><?= $this->config->item('icons')['dashboard/sales_conversion']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content" id="app">
        <sales_conversion></sales_conversion>
    </div>
    <template id="sales_conversion">
      <div>
      <?php hooks()->do_action('before_dashboards_content'); ?>
        <div class="row mb20" style="background: white;">
          <div class="col-md-12">
            <div class="">
              <div class="row">
                <div class="col-md-6">
                  <div class="row">
                    <div class="col-md-12 bgbox">
                      <div class="col-md-9">
                        <select class="form-control" name="period_filter" id="period_filter"
                                v-model="period_filter" @change="load_data($event)">
                                <option value="30d"><?= _l('filter_period_last_30d'); ?></option>
                                <option value="t"><?= _l('filter_period_today'); ?></option>
                                <option value="y"><?= _l('filter_period_yesterday'); ?></option>
                                <option value="w"><?= _l('filter_period_current_week'); ?></option>
                                <option value="lw"><?= _l('filter_period_last_week'); ?></option>
                                <option value="m"><?= _l('filter_period_current_month'); ?></option>
                                <option value="lm"><?= _l('filter_period_last_month'); ?></option>
                                <option value="yr"><?= _l('filter_period_current_year'); ?></option>
                                <option value="lyr"><?= _l('filter_period_last_year'); ?></option>
                                <option value="p"><?= _l('filter_period_range'); ?></option>
                        </select>
                      </div>
                      <div class="col-md-3">
                        <a href="#" class="btn btn-primary d-inline" @click.prevent="load_data"><i
                            class="fa fa-refresh"></i></a>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="row" v-if=" period_filter == 'p' ">
                    <div class="col-md-8">
                      <vue-datepicker @selected-date="updated"></vue-datepicker>
                    </div>
                    <div class="col-md-4">
                      <div class="bgbox">
                        <button class="btn btn-primary" @click="load_data()"><?= _l('filter_apply'); ?></button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="row mb20">
          <div class="col-md-3">
            <div class="row">
              <div class="col-md-12 bgbox mb20" style="background: rgb(16, 127, 140);">
                <h3 class="btitle">{{ $t("sales_conversion.chart_title_lead_convertion_ratio") }}</h3>
                <skeleton width="100%" bgcolor="rgb(16, 127, 140)" v-show="is_loading"></skeleton>
                <h3 class="btitle" v-show="!is_loading">
                  <div v-if="valid_conversion_ratio">
                  <span v-text="leads_for_a_win">-</span>:<span v-text="base_ration_leads_for_client">-</span>
                  </div>

                  <span v-if="show_percent">(<span v-text="percent_leads_for_client">-</span>%)</span></h3>
                <p class="subtitle">{{ $t("sales_conversion.chart_subtitle_lead_convertion_ratio") }}</p>
              </div>
              <div class="col-md-12 bgbox" style="background: #15807e">
                <span class="figure-title">{{ $t("sales_conversion.chart_title_leads") }}</span>
                <skeleton width="100%" bgcolor="transparent" v-show="is_loading"></skeleton>
                <span class="figure pull-right" v-show="!is_loading" v-text=global.total_leads>-</span>
              </div>
              <div class="col-md-12 bgbox mb20" style="background: #199487">
                <span class="figure-title">{{ $t("sales_conversion.chart_title_opportunitites") }}</span>
                <skeleton width="100%" bgcolor="transparent" v-show="is_loading"></skeleton>
                <span class="figure pull-right" v-show="!is_loading" v-text=global.total_opportunitites>-</span>
              </div>
            </div>


            <!--<div class="row">
              <div class="col-md-12 bgbox" style="background: #1da381">
                <span class="figure-title">No status</span>
                <skeleton width="100%" bgcolor="transparent" v-show="is_loading"></skeleton>
                <span class="figure pull-right" v-show="!is_loading" v-text="global.total_without_status">-</span>
              </div>
              <div class="col-md-12 bgbox" style="background: #1da381">
                <span class="figure-title">Lost</span>
                <skeleton width="100%" bgcolor="transparent" v-show="is_loading"></skeleton>
                <span class="figure pull-right" v-show="!is_loading" v-text="global.total_lost">-</span>
              </div>
              <div class="col-md-12 bgbox mb20" style="background: #1da381">
                <span class="figure-title">Junk</span>
                <skeleton width="100%" bgcolor="transparent" v-show="is_loading"></skeleton>
                <span class="figure pull-right" v-show="!is_loading" v-text="global.total_junk">-</span>
              </div>
            </div>-->
            <div class="row mb20">
              <div class="col-md-12 bgbox" v-if="statuses != null" Xv-show="global['total_status_' + status.id] > 0" v-for="status in statuses" v-bind:style="{background: status.color}">
                <span class="figure-title overflow-ellipsis">{{ status['name'] }}</span>
                <skeleton width="100%" bgcolor="transparent" v-show="is_loading"></skeleton>
                <span class="figure pull-right overflow-ellipsis" v-show="!is_loading">{{ global['total_status_' + status.id] }}</span>
              </div>
            </div>
          </div>
          <div class="col-md-9">
            <div class="row mb20">
              <div class="col-md-12 p-0">
                <div class="dashcard d-ml20">
                  <div class="dashcard__header border">
                    <skeleton height="30px" bgcolor="#f8f8f8" width="100%" v-show="is_loading"></skeleton>
                    <div class="dashcard__header_title" v-show="!is_loading" v-if="global.text"
                         v-text="global.text.title_chart_converted_leads">
                      {{ $t("sales_conversion.default_converted_leads") }}
                    </div>
                    <div class="dashcard__header_title" v-show="!is_loading"
                         v-if="!global.text">{{ $t("sales_conversion.default_converted_leads") }}
                    </div>

                    <div class="dashcard__header_right_title"></div>
                  </div>
                  <skeleton height="150px" width="100%" v-show="is_loading"></skeleton>
                  <div class="dashcard__body" v-show="!is_loading">
                    <div class="dashcard__widget1">
                      <h4 class="dashcard__widget1_title"></h4>
                    </div>
                    <div class="dashcard__chart">
                      <div id="chart-1" style=" margin: 0 auto"></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row mb20">
              <div class="col-md-6  p-0">
                <div class="dashcard d-ml20">
                  <div class="dashcard__header border">
                    <div class="dashcard__header_title">{{ $t("sales_conversion.leads_to_opportunity") }}</div>
                    <div class="dashcard__header_right_title"></div>
                  </div>
                  <skeleton height="170px" width="100%" v-show="is_loading"></skeleton>
                  <div class="dashcard__body" v-show="!is_loading">
                    <div class="dashcard__widget1">
                      <h4 class="dashcard__widget1_title"></h4>
                    </div>
                    <div class="dashcard__chart">
                      <div id="chart-2"></div>
                    </div>
                    <p class="block-center text-center boxed-primary"
                       style="width: 190px;">{{ $t("sales_conversion.leads_to_opportunity") }}</p>
                  </div>
                </div>
              </div>
              <div class="col-md-6  p-0">
                <div class="dashcard d-ml20">
                  <div class="dashcard__header border">
                    <div class="dashcard__header_title">{{ $t("sales_conversion.opportunity_to_win") }}</div>
                    <div class="dashcard__header_right_title"></div>
                  </div>
                  <skeleton height="170px" width="100%" v-show="is_loading"></skeleton>
                  <div class="dashcard__body" v-show="!is_loading">
                    <div class="dashcard__widget1">
                      <h4 class="dashcard__widget1_title"></h4>
                    </div>
                    <div class="dashcard__chart">
                      <div id="chart-3"></div>
                    </div>
                    <p class="block-center text-center boxed-primary"
                       style="width: 190px;">{{ $t("sales_conversion.opportunity_to_win") }}</p>
                  </div>
                </div>
              </div>
            </div>

            <div v-cloak class="row p-0" style="display: flex; flex-wrap: wrap;">

              <div class="col-sm-6 col-md-6 p-0 mb20" v-for="agent in sales_agents">
                <div class="dashcard d-ml20">
                  <div class="dashcard__header border">
                    <div class="dashcard__header_title">{{ agent.SalesAgent }}
                      <br><span class="text-muted"
                                v-if="agent.PositionName">({{ agent.PositionName }})</span>
                    </div>
                    <div class="dashcard__header_right_title"></div>
                  </div>
                  <div class="dashcard__body" style="padding-top:0">

                    <div class="dashcard__widget1">
                        <div class="row" >
                            <div class="col-sm-4 p-0 m-0" style="margin-bottom:5px;">
                                <div style="padding:2px;">
                                    <h5 style="color:#73b8bf;" class="text-center"></h5>
                                    <div class="text-center">
                                        <img class="text-center" style="text-align: center; max-height:120px;" class="circular-square" :src="agent.profile_pic" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-8 m-0" style="margin-bottom:5px;">
                              <div class="dashcard__header border">
                                  <div class="dashcard__header_title"><?= _l('conversion_rate') ?></div>

                                  <span v-if="agent.trend == 'good'" class="tx-good"><i
                                      class="fa fa-arrow-up"></i> {{ agent.conversion_rate }}%</span>
                                 <span v-if="agent.trend == 'bad'" class="tx-bad"><i
                                     class="fa fa-arrow-down"></i> {{ agent.conversion_rate }}%</span>
                                  <span v-if="agent.trend == ''" class="tx-primary">{{ agent.conversion_rate }}%</span>

                              </div>

                              <div class="dashcard__header border">
                                  <div class="dashcard__header_title"><?= _l('owned_leads') ?></div>
                                  <span v-text="agent.owned_leads"></span>
                              </div>
                              <div class="dashcard__header border">
                                  <div class="dashcard__header_title"><?= _l('converted_leads') ?></div>
                                  <span v-text="agent.owned_converted_leads"></span>
                              </div>


                            </div>
                        </div>
                    </div>




                  </div>
                </div>
              </div>











            </div>

          </div>
        </div>
        </div>
      </div>
    </template>

    <?php show_footer(); ?><?php init_tail(); ?>
<div>
