<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['dashboard']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content" id="app">
        <sales_cycle></sales_cycle>
    </div>
    <template id="sales_cycle">
        <div>
            <?php hooks()->do_action('before_dashboards_content'); ?>
            <div class="row mb20">
                <div class="col-md-12">
                    <div class="" style="background: white;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12 bgbox">
                                        <div class="col-md-9">
                                            <select class="form-control" name="period_filter" id="period_filter"
                                                    v-model="period_filter" @change="filter_on_change($event)">
                                                <option value="30d"><?= _l('filter_period_last_30d'); ?></option>
                                                <option value="t"><?= _l('filter_period_today'); ?></option>
                                                <option value="y"><?= _l('filter_period_yesterday'); ?></option>
                                                <option value="w"><?= _l('filter_period_current_week'); ?></option>
                                                <option value="lw"><?= _l('filter_period_last_week'); ?></option>
                                                <option value="m"><?= _l('filter_period_current_month'); ?></option>
                                                <option value="lm"><?= _l('filter_period_last_month'); ?></option>
                                                <option value="yr"><?= _l('filter_period_current_year'); ?></option>
                                                <option value="lyr"><?= _l('filter_period_last_year'); ?></option>
                                                <option value="p"><?= _l('filter_period_range'); ?></option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <a href="#" class="btn btn-primary d-inline" @click.prevent="filter_on_change"><i
                                                        class="fa fa-refresh"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row" v-if=" period_filter == 'p' ">
                                    <div class="col-md-8">
                                        <vue-datepicker @selected-date="updated"></vue-datepicker>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="bgbox">
                                            <button class="btn btn-primary" @click="filter_on_change()"><?= _l('filter_apply'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row  pl-5 pr-5">
                <div class="col-md-12 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('sales_cycle_funnel_title') ?></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <chart-funnel :extra-data="extraData" :labels="labels" :values="values" :sub-labels="subLabels"></chart-funnel>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row  pl-5 pr-5">
                <div class="col-md-12 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('chart_cycle_length_weekly') ?></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <div id="chart_avarage_sales_cycle" style="min-width: 600px"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row  pl-5 pr-5">
                <div v-for="employee in employees" :key="employee.staffid" class="col-sm-6 col-md-4 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title" v-text="employee.SalesAgent"></div>
                            <div class="dashcard__header_right_title" v-text="employee.PositionName"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <div class="row">
                                    <div class="col-sm-4 p-0 m-0" style="margin-bottom:5px;">
                                        <div style="padding:2px;">
                                            <h5 style="color:#73b8bf;" class="text-center"></h5>
                                            <div class="text-center">
                                                <img class="text-center" style="text-align: center; max-height:120px;" class="circular-square" :src="employee.profile_pic"/>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-8 m-0" style="margin-bottom:5px;">
                                        <div class="dashcard__header border">
                                            <div class="dashcard__header_title"><?= _l('converted_opportunities') ?></div>
                                            <div class="dashcard__header_right_title" v-text="employee.converted_to_opp"></div>
                                        </div>
                                        <div class="dashcard__header border">
                                            <div class="dashcard__header_title"><?= _l('generated') ?></div>
                                            <div class="dashcard__header_right_title" v-text="employee.total_leads"></div>
                                        </div>

                                        <div class="dashcard__header border">
                                            <div class="dashcard__header_title"><?= _l('lead_conversion_rate') ?></div>
                                            <div class="dashcard__header_right_title" v-text="employee.conversion_rate+' %'"></div>
                                        </div>

                                        <div class="dashcard__chart">
                                            <div id="chart_lead_conversion_1"></div>
                                        </div>

                                        <div class="dashcard__header border">
                                            <div class="dashcard__header_title"><?= _l('sales_cycle_length') ?></div>
                                            <div class="dashcard__header_right_title" v-if="employee.scl" v-text="employee.scl+' days'"></div>
                                            <div class="dashcard__header_right_title" v-else-if="!employee.scl" v-text="'-'"></div>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 p-0 m-0" style="margin-bottom:5px;">
                                        <div class="dashcard__chart">
                                            <hc-spline :series_data="employee.scl_hitory" :chart_id="'scl_' + employee.staffid"/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </template>

    <?php show_footer(); ?><?php init_tail(); ?>
    <div>
