<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['dashboard']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content" id="app">
        <sales_kpi></sales_kpi>
    </div>
    <template id="sales_kpi">
        <div>
            <?php hooks()->do_action('before_dashboards_content'); ?>
            <div class="row mb20">
                <div class="col-md-12">
                    <div class="" style="background: white;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12 bgbox">
                                        <div class="col-md-9">
                                            <select class="form-control" name="period_filter" id="period_filter"
                                                    v-model="period_filter" @change="filter_on_change($event)">
                                                <option value="30d"><?= _l('filter_period_last_30d'); ?></option>
                                                <option value="t"><?= _l('filter_period_today'); ?></option>
                                                <option value="y"><?= _l('filter_period_yesterday'); ?></option>
                                                <option value="w"><?= _l('filter_period_current_week'); ?></option>
                                                <option value="lw"><?= _l('filter_period_last_week'); ?></option>
                                                <option value="m"><?= _l('filter_period_current_month'); ?></option>
                                                <option value="lm"><?= _l('filter_period_last_month'); ?></option>
                                                <option value="yr"><?= _l('filter_period_current_year'); ?></option>
                                                <option value="lyr"><?= _l('filter_period_last_year'); ?></option>
                                                <option value="p"><?= _l('filter_period_range'); ?></option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <a href="#" class="btn btn-primary d-inline" @click.prevent="filter_on_change"><i
                                                        class="fa fa-refresh"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row" v-if=" period_filter == 'p' ">
                                    <div class="col-md-8">
                                        <vue-datepicker @selected-date="updated"></vue-datepicker>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="bgbox">
                                            <button class="btn btn-primary" @click="filter_on_change()"><?= _l('filter_apply'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row pl-5 pr-5">
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('sales_kpi__nuber_of_sales') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="sales_num"></h4>
                            </div>
                        </div>
                        <div class="dashcard__footer">
                            <!--<span class="dashcard__widget1_figures float-left"><span class="tx-good"><i class="fas fa-bullseye"></i><i class="fa fa-carret-up"></i> </span></span>-->
                            <span class="dashcard__widget1_figures float-right">
                      <span v-if="delta_sales_num > 0" class="tx-good"><i class="fa fa-calendar"></i>
                        <i class="fa fa-carret-up"></i> +<span v-text="delta_sales_num"></span>% <?= _l('than_previous'); ?>
                      </span>
                      <span v-else-if="delta_sales_num < 0" class="tx-bad"><i class="fa fa-calendar"></i>
                        <i class="fa fa-carret-down"></i> -<span v-text="delta_sales_num"></span>% <?= _l('than_previous'); ?>
                      </span>
                      <span v-else-if="delta_sales_num == 0" class="tx-normal"><i class="fa fa-calendar"></i>
                         0% <?= _l('than_previous'); ?>
                      </span>
                    </span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('sales_kpi__new_revenue') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="sales_value"></h4>
                            </div>
                        </div>
                        <div class="dashcard__footer">
                            <!--<span class="dashcard__widget1_figures float-left"><span class="tx-good"><i class="fas fa-bullseye"></i><i class="fa fa-carret-up"></i> </span></span>-->
                            <span class="dashcard__widget1_figures float-right">
                      <span v-if="delta_sales_value > 0" class="tx-good"><i class="fa fa-calendar"></i>
                        <i class="fa fa-carret-up"></i> +<span v-text="delta_sales_value"></span>% <?= _l('than_previous'); ?>
                      </span>
                      <span v-else-if="delta_sales_value < 0" class="tx-bad"><i class="fa fa-calendar"></i>
                        <i class="fa fa-carret-down"></i> -<span v-text="delta_sales_value"></span>% <?= _l('than_previous'); ?>
                      </span>
                      <span v-else-if="delta_sales_value == 0" class="tx-normal"><i class="fa fa-calendar"></i>
                         0% <?= _l('than_previous'); ?>
                      </span>
                    </span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('sales_kpi__cost') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="total_sales_cost"></h4>
                            </div>
                        </div>
                        <div class="dashcard__footer">
                            <!--<span class="dashcard__widget1_figures float-left"><span class="tx-good"><i class="fas fa-bullseye"></i><i class="fa fa-carret-up"></i> </span></span>-->
                            <span class="dashcard__widget1_figures float-right">
                      <span v-if="delta_sales_cost > 0" class="tx-good"><i class="fa fa-calendar"></i>
                        <i class="fa fa-carret-up"></i> +<span v-text="delta_sales_cost"></span>% <?= _l('than_previous'); ?>
                      </span>
                      <span v-else-if="delta_sales_cost < 0" class="tx-bad"><i class="fa fa-calendar"></i>
                        <i class="fa fa-carret-down"></i> -<span v-text="delta_sales_cost"></span>% <?= _l('than_previous'); ?>
                      </span>
                      <span v-else-if="delta_sales_cost == 0" class="tx-normal"><i class="fa fa-calendar"></i>
                         0% <?= _l('than_previous'); ?>
                      </span>
                    </span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('sales_kpi__profit_by_sale') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center" ref="profit_per_sale"></h4>
                            </div>
                        </div>
                        <div class="dashcard__footer">
                            <!--<span class="dashcard__widget1_figures float-left"><span class="tx-good"><i class="fas fa-bullseye"></i><i class="fa fa-carret-up"></i> </span></span>-->
                            <span class="dashcard__widget1_figures float-right">
                      <span v-if="delta_total_sales_profit > 0" class="tx-good"><i class="fa fa-calendar"></i>
                        <i class="fa fa-carret-up"></i> +<span v-text="delta_total_sales_profit"></span>% <?= _l('than_previous'); ?>
                      </span>
                      <span v-else-if="delta_total_sales_profit < 0" class="tx-bad"><i class="fa fa-calendar"></i>
                        <i class="fa fa-carret-down"></i> -<span v-text="delta_total_sales_profit"></span>% <?= _l('than_previous'); ?>
                      </span>
                      <span v-else-if="delta_total_sales_profit == 0" class="tx-normal"><i class="fa fa-calendar"></i>
                         0% <?= _l('than_previous'); ?>
                      </span>
                    </span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row pl-5 pr-5">
                <div class="col-md-12 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('sales_kpi__new_generated_sales_revenue') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__chart">
                                <div id="chart_new_generated_sales_revenue"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php /*<div class="col-md-4 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title"><?= _l('COST BREAKDOWN') ?></div>
                    <div class="dashcard__header_right_title"></div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__chart"><div id="chart_cost_breakdown"></div></div>
                </div>
            </div>
        </div>*/ ?>
            </div>

            <?php /*
    <div class="row p-0 m-0">
        <div class="col-md-4 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title"><?= _l('UP/CROSS SELL') ?></div>
                    <div class="dashcard__header_right_title"></div>
                </div>
                <div class="dashcard__body">
                            <div class="row" style="padding:2px;">
                                <div class="col-md-6 col-lg-6">
                                    <span class="pull-left text-black">Revenue </span>
                                </div>
                                <div class="col-md-6 col-lg-6" >
                                    <div style="font-size:18px;" class="tx-good pull-right">$19,654</div>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-6 col-lg-6">
                                    <span class="pull-left text-black">% of Revenue </span>
                                </div>
                                <div class="col-md-6 col-lg-6" >
                                    <div style="font-size:18px;" class="tx-good pull-right">11%</div>
                                </div>
                            </div>
                            <hr>
                            <h5 class="btitle-black"><?= _l('CHURN') ?></h5>
                            <div class="row" style="padding:2px;">
                                <div class="col-md-6 col-lg-6">
                                    <span class="pull-left text-black">Total</span>
                                </div>
                                <div class="col-md-6 col-lg-6" >
                                    <div style="font-size:18px;" class="tx-good pull-right">33</div>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-6 col-lg-6">
                                    <span class="pull-left text-black">Rate</span>
                                </div>
                                <div class="col-md-6 col-lg-6" >
                                    <div style="font-size:18px;" class="tx-good pull-right">2%</div>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-6 col-lg-6">
                                    <span class="pull-left text-black">Revenue</span>
                                </div>
                                <div class="col-md-6 col-lg-6" >
                                    <div style="font-size:18px;" class="tx-good pull-right">$54,568</div>
                                </div>
                            </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title"><?= _l('ACCUMULATED REVENUE') ?></div>
                    <div class="dashcard__header_right_title"></div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__chart"><div id="chart_accumulated_revenue"></div></div>
                </div>
            </div>
        </div>
        <div class="col-md-4 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title"><?= _l('INCREMENTAL SALES') ?></div>
                    <div class="dashcard__header_right_title"></div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__chart"><div id="chart_incremental_sales"></div></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row p-0 m-0">
        <div class="col-sm-6 col-md-3 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title">Paul C.</div>
                    <div class="dashcard__header_right_title"><?= _l('Sales Rep.') ?></div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__widget1">
                        <h4 class="dashcard__widget1_title">$675</h4>
                        <span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="tx-good"><i class="fas fa-check"></i> Target of $600 meet</span></p></span>
                    </div>
                </div>
                <div class="dashcard__footer">
                    <span class="dashcard__widget1_figures float-left"><span class="tx-neutral">Profit $15,66</span></span>
                    <span class="dashcard__widget1_figures float-right"><span class="tx-neutral">Sales: 4</span></span>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-md-3 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title">Bogdan M.</div>
                    <div class="dashcard__header_right_title"><?= _l('Sales Rep.') ?></div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__widget1">
                    <h4 class="dashcard__widget1_title">$675</h4>
                    <span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="tx-good"><i class="fas fa-check"></i> Target of $600 meet</span></p></span>
                    </div>
                </div>
                <div class="dashcard__footer">
                    <span class="dashcard__widget1_figures float-left"><span class="tx-neutral">Profit $15,66</span></span>
                    <span class="dashcard__widget1_figures float-right"><span class="tx-neutral">Sales: 4</span></span>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-md-3 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title">Marius</div>
                    <div class="dashcard__header_right_title"><?= _l('Sales Rep.') ?></div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__widget1">
                    <h4 class="dashcard__widget1_title">$322</h4>
                    <span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="tx-bad"><i class="fas fa-times"></i> Target of $600 not meet</span></p></span>
                    </div>
                </div>
                <div class="dashcard__footer">
                    <span class="dashcard__widget1_figures float-left"><span class="tx-neutral">Profit $15,66</span></span>
                    <span class="dashcard__widget1_figures float-right"><span class="tx-neutral">Sales: 4</span></span>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-md-3 p-10 m-0">
            <div class="dashcard">
                <div class="dashcard__header border">
                    <div class="dashcard__header_title">Paul T.</div>
                    <div class="dashcard__header_right_title"><?= _l('Sales Rep.') ?></div>
                </div>
                <div class="dashcard__body">
                    <div class="dashcard__widget1">
                    <h4 class="dashcard__widget1_title">$65</h4>
                    <span class="dashcard__widget1_figures"><p class="mg-b-0 tx-sm"><span class="tx-bad"><i class="fas fa-times"></i> Target of $600 not meet</span></p></span>
                    </div>
                </div>
                <div class="dashcard__footer">
                    <span class="dashcard__widget1_figures float-left"><span class="tx-neutral">Profit $15,66</span></span>
                    <span class="dashcard__widget1_figures float-right"><span class="tx-neutral">Sales: 4</span></span>
                </div>
            </div>
        </div>
    </div>
    */ ?>


        </div>
    </template>

    <?php show_footer(); ?><?php init_tail(); ?>
    <div>
