<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
  <div class="breadcrumb col-md-12">
    <a href="<?php echo admin_url(); ?>"><?= _l('title_dashboard_lead_generation'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a
      href="<?php echo admin_url("okr/dashboard"); ?>"><?php echo _l('okr'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
  </div>

  <div class="admin-title">
    <h1><?= $this->config->item('icons')['inbound_lead_generation']; ?><?php echo html_entity_decode($title); ?></h1>
  </div>
  <div class="content" id="app">
    <sales_opportunity></sales_opportunity>
  </div>
<template id="sales_opportunity">
  <div>
  <?php hooks()->do_action('before_dashboards_content'); ?>
    <div class="row mb20">
      <div class="col-md-12">
        <div class="" style="background: white;">
          <div class="row">
            <div class="col-md-6">
              <div class="row">
                <div class="col-md-12 bgbox">
                  <div class="col-md-9">
                    <select class="form-control" name="period_filter" id="period_filter"
                            v-model="period_filter" @change="filter_on_change($event)">
                            <option value="30d"><?= _l('filter_period_last_30d'); ?></option>
                            <option value="t"><?= _l('filter_period_today'); ?></option>
                            <option value="y"><?= _l('filter_period_yesterday'); ?></option>
                            <option value="w"><?= _l('filter_period_current_week'); ?></option>
                            <option value="lw"><?= _l('filter_period_last_week'); ?></option>
                            <option value="m"><?= _l('filter_period_current_month'); ?></option>
                            <option value="lm"><?= _l('filter_period_last_month'); ?></option>
                            <option value="yr"><?= _l('filter_period_current_year'); ?></option>
                            <option value="lyr"><?= _l('filter_period_last_year'); ?></option>
                            <option value="p"><?= _l('filter_period_range'); ?></option>
                    </select>
                  </div>
                  <div class="col-md-3">
                    <a href="#" class="btn btn-primary d-inline" @click.prevent="filter_on_change"><i
                        class="fa fa-refresh"></i></a>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="row" v-if=" period_filter == 'p' ">
                <div class="col-md-8">
                  <vue-datepicker @selected-date="updated"></vue-datepicker>
                </div>
                <div class="col-md-4">
                  <div class="bgbox">
                    <button class="btn btn-primary" @click="filter_on_change()"><?= _l('filter_apply'); ?></button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row pl-5 pr-5">
      <div class="col-md-6 p-10 m-0">
        <div class="row">

          <div class="col-sm-6 mb20">
            <div class="dashcard-2">
              <div class="dashcard__header border">
                <div class="dashcard__header_title"><?= _l('opportunities'); ?></div>
              </div>
              <div class="dashcard__body background-text-container">
                <div class="dashcard__widget1">
                  <span class="dashcard__widget1_figures text-right" v-if="count_opportunities > previous_opportunities">
                    <p class="mg-b-0 tx-26">{{ count_opportunities }}<span class="tx-good">({{ tx_opportunities_change }})</span></p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="count_opportunities < previous_opportunities">
                    <p class="mg-b-0 tx-26">{{ count_opportunities }}<span class="tx-bad">({{ tx_opportunities_change }})</span></p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="count_opportunities == previous_opportunities">
                    <p class="mg-b-0 tx-26">{{ count_opportunities }}</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-if="tx_opportunities_change != ''">
                    <p class="mg-b-0 tx-sm"><?= _l('vs. previous period'); ?></p>
                  </span>

                  <div class="background-text"><span class="dropcap">O</span><span class="afterdrop">pportunity</span></div>
                </div>
              </div>
            </div>
          </div>

          <div class="col-sm-6 mb20">
            <div class="dashcard-2">
              <div class="dashcard__header border">
                <div class="dashcard__header_title"><?= _l('win_rate'); ?></div>
              </div>
              <div class="dashcard__body background-text-container">
                <div class="dashcard__widget1">
                  <span class="dashcard__widget1_figures text-right" v-if="current_win_rate > previous_win_rate">
                    <p class="mg-b-0 tx-26">{{ current_win_rate }}%  <span class="tx-good">({{ tx_win_rate_change }})</span></p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="current_win_rate < previous_win_rate">
                    <p class="mg-b-0 tx-26">{{ current_win_rate }}% <span class="tx-bad">({{ tx_win_rate_change }})</span></p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="current_win_rate == previous_win_rate">
                    <p class="mg-b-0 tx-26">{{ current_win_rate }}%</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-if="tx_win_rate_change != ''">
                    <p class="mg-b-0 tx-sm"><?= _l('vs. previous period'); ?></p>
                  </span>

                  <div class="background-text"><span class="dropcap">W</span><span class="afterdrop">in rate</span></div>
                </div>
              </div>
            </div>
          </div>


          <div class="col-sm-6 mb20">
            <div class="dashcard-2">
              <div class="dashcard__header border">
                <div class="dashcard__header_title"><?= _l('purchase_value'); ?></div>
              </div>
              <div class="dashcard__body background-text-container">
                <div class="dashcard__widget1">
                  <span class="dashcard__widget1_figures text-right" v-if="current_purchase_value_otf > previous_purchase_value_otf">
                    <p class="mg-b-0 tx-26">{{ current_purchase_value_otf }} {{ base_currency }}</p><p class="text-right tx-good">OTF ({{ tx_purchase_value_change_otf }})</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="current_purchase_value_otf < previous_purchase_value_otf">
                    <p class="mg-b-0 tx-26">{{ current_purchase_value_otf }} {{ base_currency }}</p><p class="text-right tx-bad">OTF ({{ tx_purchase_value_change_otf }})</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="current_purchase_value_otf == previous_purchase_value_otf">
                    <p class="mg-b-0 tx-26">OTF: {{ current_purchase_value_otf }} {{ base_currency }}</p>
                  </span>


                  <span class="dashcard__widget1_figures text-right" v-if="current_purchase_value_mrr > previous_purchase_value_mrr">
                    <p class="mg-b-0 tx-26">{{ current_purchase_value_mrr }} {{ base_currency }}</p><p class="text-right tx-good">MRR ({{ tx_purchase_value_change_mrr }})</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="current_purchase_value_mrr < previous_purchase_value_mrr">
                    <p class="mg-b-0 tx-26">{{ current_purchase_value_mrr }} {{ base_currency }}</p><p class="text-right tx-bad">MRR ({{ tx_purchase_value_change_mrr }})</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="current_purchase_value_mrr == previous_purchase_value_mrr">
                    <p class="mg-b-0 tx-26">MRR: {{ current_purchase_value_mrr }} {{ base_currency }}</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-if="tx_purchase_value_change_otf != '' || tx_purchase_value_change_mrr != '' ">
                    <p class="mg-b-0 tx-sm"><?= _l('vs. previous period'); ?></p>
                  </span>

                  <div class="background-text"><span class="dropcap">P</span><span class="afterdrop">urchase</span></div>
                </div>
              </div>
            </div>
          </div>

          <div class="col-sm-6 mb20">
            <div class="dashcard-2">
              <div class="dashcard__header border">
                <div class="dashcard__header_title"><?= _l('average_purchase_rate'); ?></div>
              </div>
              <div class="dashcard__body background-text-container">
                <div class="dashcard__widget1">
                  <span class="dashcard__widget1_figures text-right" v-if="avg_current_purchase_value_otf > avg_previous_purchase_value_otf">
                    <p class="mg-b-0 tx-26">{{ avg_current_purchase_value_otf }} {{ base_currency }}</p><p class="text-right tx-good">OTF ({{ tx_avg_purchase_value_change_otf }})</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="avg_current_purchase_value_otf < avg_previous_purchase_value_otf">
                    <p class="mg-b-0 tx-26">{{ avg_current_purchase_value_otf }} {{ base_currency }}</p><p class="text-right tx-bad">OTF ({{ tx_avg_purchase_value_change_otf }})</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="avg_current_purchase_value_otf == avg_previous_purchase_value_otf">
                    <p class="mg-b-0 tx-26"><?= _l('abbr_otf'); ?>: {{ avg_current_purchase_value_otf }} {{ base_currency }}</p>
                  </span>


                  <span class="dashcard__widget1_figures text-right" v-if="avg_current_purchase_value_mrr > avg_previous_purchase_value_mrr">
                    <p class="mg-b-0 tx-26">{{ avg_current_purchase_value_mrr }} {{ base_currency }}</p><p class="text-right tx-good">MRR ({{ tx_avg_purchase_value_change_mrr }})</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="avg_current_purchase_value_mrr < avg_previous_purchase_value_mrr">
                    <p class="mg-b-0 tx-26">{{ avg_current_purchase_value_mrr }} {{ base_currency }}</p><p class="text-right tx-bad">MRR ({{ tx_avg_purchase_value_change_mrr }})</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-else-if="avg_current_purchase_value_mrr == avg_previous_purchase_value_mrr">
                    <p class="mg-b-0 tx-26"><?= _l('abbr_mrr'); ?>: {{ avg_current_purchase_value_mrr }} {{ base_currency }}</p>
                  </span>

                  <span class="dashcard__widget1_figures text-right" v-if="tx_avg_purchase_value_change_otf != '' || tx_avg_purchase_value_change_mrr != '' ">
                    <p class="mg-b-0 tx-sm"><?= _l('vs. previous period'); ?></p>
                  </span>

                  <div class="background-text"><span class="dropcap">A</span><span class="afterdrop">verage</span></div>
                </div>
              </div>
            </div>
          </div>


        </div>
      </div>
      <div class="col-md-6">
        <div class="row">
          <div class="col-12 m-0 p-10">
            <div class="dashcard-2">
              <div class="dashcard__header border">
                <div class="dashcard__header_title border mt-3">{{ $t("message.chart_reasons_lost_opportunities") }}</div>
              </div>
              <div class="dashcard__header_right_title"></div>
              <div class="dashcard__chart">
                <div id="chart_reasons_lost_opportunities"></div>
              </div>
            </div>
          </div>
        </div>
      </div>


    </div>

    <div class="row pl-5 pr-5">
      <div class="col-md-12">
        <div class="row">
          <div class="col-12 m-0 p-10">
            <div class="dashcard">
              <div class="dashcard__header border">
                <div class="dashcard__header_title"><?= _l('opportunity_details'); ?></div>
                <div class="dashcard__header_right_title d-flex">

                  <div class="d-flex">

                    <h5 style="align-self: center"><?= _l('stage_name'); ?>: </h5>
                    <select class="form-control" @change="reload_table_data()" v-model="opp_status">
                      <option @click.prevent="opp_status = null" value="">All</option>
                      <option v-for="stage in stages" :value="stage.id" :key="stage.id" @click.prevent="opp_status = stage.id">{{ stage.name }}
                      </option>
                    </select>
                  </div>
                </div>
              </div>
              <div class="dashcard__body">
                <div class="dashcard__widget_table">
                  <table class="table table-responsive mg-b-0 tx-12 w-100">
                    <thead>
                    <tr class="tx-10">
                      <th class="wd-10p pd-y-5"><?= _l('sales_opportunity_id'); ?></th>
                      <th class="pd-y-5"><?= _l('sales_opportunity_first_contact'); ?></th>
                      <th class="pd-y-5 tx-right"><?= _l('sales_opportunity_sale_agent'); ?></th>
                      <th class="pd-y-5"><?= _l('sales_opportunity_company'); ?></th>
                      <th class="pd-y-5 tx-center"><?= _l('sales_opportunity_stage'); ?></th>
                      <th class="pd-y-5 tx-center"><?= _l('sales_opportunity_last_stage'); ?></th>
                      <th class="pd-y-5 tx-center"><?= _l('sales_opportunity_one_time_fee'); ?></th>
                      <th class="pd-y-5 tx-center"><?= _l('sales_opportunity_monthly_recurring_fee'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                      <tr v-for="detail in opportunities">
                      <td class="pd-l-20">
                        {{ detail.id }}
                      </td>
                      <td class="pd-l-20">
                        {{ detail.dateadded }}
                      </td>
                      <td class="pd-l-20">{{ detail.name }}</td>
                      <td class="pd-l-20">{{ detail.company }}</td>
                      <td class="pd-l-20">{{ detail.status_opportunity ? stages[detail.status_opportunity - 1].name : '' }}
                      </td>
                      <td class="pd-l-20">
                        {{ detail.last_opportunity_status ? stages[detail.last_opportunity_status - 1].name : '' }}
                      </td>
                      <td class="pd-l-20">{{ detail.opportunity_ot_value }}</td>
                      <td class="pd-l-20">{{ detail.opportunity_mo_value }}</td>
                    </tr>
                    </tbody>
                    <tfoot>
                      <tr class="tx-10">
                        <td colspan="8">
                          <infinite-loading :identifier="infiniteId" @infinite="infiniteHandler" spinner="bubbles">
                            <div slot="no-more"></div>
                            <div slot="no-results"></div>
                            <!--<div slot="spinner">Loading...</div>


                            <div slot="error" slot-scope="{ trigger }">
                            An error occured, click <a href="javascript:;" @click="trigger">here</a> to retry
                            </div-->

                        </infinite-loading>
                        </td>
                      </tr>
                    </tfoot>

                  </table>


                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</template>

</div>

<?php show_footer(); ?><?php init_tail(); ?>
</div>
