<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['dashboard']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content" id="app">
        <tactical_finance></tactical_finance>
    </div>
    <template id="tactical_finance">
        <div>
            <?php hooks()->do_action('before_dashboards_content'); ?>
            <div class="row mb20">
                <div class="col-md-12">
                    <div class="" style="background: white;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12 bgbox">
                                        <div class="col-md-9">
                                            <select class="form-control" name="period_filter" id="period_filter"
                                                    v-model="period_filter" @change="filter_on_change($event)">
                                                <option value="30d"><?= _l('filter_period_last_30d'); ?></option>
                                                <option value="t"><?= _l('filter_period_today'); ?></option>
                                                <option value="y"><?= _l('filter_period_yesterday'); ?></option>
                                                <option value="w"><?= _l('filter_period_current_week'); ?></option>
                                                <option value="lw"><?= _l('filter_period_last_week'); ?></option>
                                                <option value="m"><?= _l('filter_period_current_month'); ?></option>
                                                <option value="lm"><?= _l('filter_period_last_month'); ?></option>
                                                <option value="yr"><?= _l('filter_period_current_year'); ?></option>
                                                <option value="lyr"><?= _l('filter_period_last_year'); ?></option>
                                                <option value="p"><?= _l('filter_period_range'); ?></option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <a href="#" class="btn btn-primary d-inline" @click.prevent="filter_on_change"><i
                                                        class="fa fa-refresh"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row" v-if=" period_filter == 'p' ">
                                    <div class="col-md-8">
                                        <vue-datepicker @selected-date="updated"></vue-datepicker>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="bgbox">
                                            <button class="btn btn-primary" @click="filter_on_change()"><?= _l('filter_apply'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row pl-5 pr-5">
                <div class="col-sm-6 col-lg-4 p-10 m-0">
                    <div class="dashcard" style="min-height: 240px;">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('income') ?></div>
                            <div class="dashcard__header_right_title">
                                <?php /*<div class="btn-group">
                    <button class="btn-fin dropdown-toggle" type="button" id="filter-chart__income" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Luna curentă<span class="caret"></span></button>
                    <div class="dropdown-menu" aria-labelledby="filter-chart__income">
                      <a class="dropdown-item" href="javascript:void(0)">Luna curentă</a>
                    </div>
                  </div>*/ ?>
                                <?php /*April 15, 2017*/ ?>
                            </div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title" v-text="income_total_sum"></h4>
                                <span class="dashcard__widget1_figures">
                    <p class="mg-b-0 tx-sm">
                      <span v-if="income_delta > 0" class="tx-success"><i class="fa fa-arrow-up"></i> <span v-text="income_delta + '%'"></span></span>
                      <span v-else-if="income_delta < 0" class="tx-danger"><i class="fa fa-arrow-down"></i> <span v-text="income_delta + '%'"></span></span>
                      <span v-else-if="income_delta == 0" class="tx-primary"><span v-text="income_delta + '%'"></span></span>
                       <?= _l('from_last_period'); ?>
                     </p>
                  </span>
                            </div>
                            <div class="dashcard__chart">
                                <div id="chart__income"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6 col-lg-4 p-10 m-0">
                    <div class="dashcard" style="min-height: 240px;">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('expenses') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title" v-text="expenses_total_sum"></h4>
                                <span class="dashcard__widget1_figures">
                    <p class="mg-b-0 tx-sm">
                      <span v-if="expenses_delta > 0" class="tx-success"><i class="fa fa-arrow-up"></i> <span v-text="expenses_delta + '%'"></span></span>
                      <span v-else-if="expenses_delta < 0" class="tx-danger"><i class="fa fa-arrow-down"></i> <span v-text="expenses_delta + '%'"></span></span>
                      <span v-else-if="expenses_delta == 0" class="tx-primary"><span v-text="expenses_delta + '%'"></span></span>
                       <?= _l('from_last_period'); ?>
                     </p>
                  </span>
                            </div>
                            <div class="dashcard__chart">
                                <div id="chart__expenses"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6 col-lg-4 p-10 m-0">
                    <div class="dashcard" style="min-height: 240px;">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('net_profit') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title" v-text="net_profit_total_sum"></h4>
                                <span class="dashcard__widget1_figures">
                    <p class="mg-b-0 tx-sm">
                      <span v-if="net_profit_delta > 0" class="tx-success"><i class="fa fa-arrow-up"></i> <span v-text="net_profit_delta + '%'"></span></span>
                      <span v-else-if="net_profit_delta < 0" class="tx-danger"><i class="fa fa-arrow-down"></i> <span v-text="net_profit_delta + '%'"></span></span>
                      <span v-else-if="net_profit_delta == 0" class="tx-primary"><span v-text="net_profit_delta + '%'"></span></span>
                      <?= _l('from_last_period'); ?>
                     </p>
                  </span>
                            </div>
                            <div class="dashcard__chart">
                                <div id="chart__net_profit"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6 col-lg-6 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('sales_by_product') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body p-0">
                            <div class="dashcard__widget_table">
                                <table-products-sold :period_filter="period_filter" :date_from="date_from" :date_to="date_to"/>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-6 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('sales_by_customer') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body p-0">
                            <div class="dashcard__widget_table">
                                <table-customer-sales :period_filter="period_filter" :date_from="date_from" :date_to="date_to"/>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php /*
        <div class="row p-0 m-0">
          <div class="col-sm-6 col-lg-6 p-10 m-0">
            <div class="dashcard">
              <div class="dashcard__header border">
                <div class="dashcard__header_title"><?= _l('ap_ar_balance') ?></div>
                <div class="dashcard__header_right_title"></div>
              </div>
              <div class="dashcard__body">
                <div class="dashcard__chart">
                  <div id="chart__ap_ar_balance"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-sm-6 col-lg-6 p-10 m-0">
            <div class="dashcard">
              <div class="dashcard__header border">
                <div class="dashcard__header_title"><?= _l('quickbooks_revenue') ?></div>
                <div class="dashcard__header_right_title"></div>
              </div>
              <div class="dashcard__body">
                <h4 class="dashcard__widget1_title">$332,402</h4>
                <div class="dashcard__chart">
                  <div id="chart__quickbooks_revenue"></div>
                </div>
              </div>
            </div>

            <div class="dashcard">
              <div class="dashcard__header border">
                <div class="dashcard__header_title"><?= _l('expenses') ?></div>
                <div class="dashcard__header_right_title"></div>
              </div>
              <div class="dashcard__body">
                <h4 class="dashcard__widget1_title">$332,402</h4>
                <div class="dashcard__chart">
                  <div id="chart__expenses_compare"></div>
                </div>
              </div>
            </div>
          </div>
        </div>
        */ ?>

        </div>
    </template>

    <template id="table_products_sold">
        <div>

            <table class="table table-responsive table-430 mg-b-0 tx-12" v-cloak>
                <thead>
                <tr class="tx-10">
                    <th class="wd-10p pd-y-5"><?= _l("tf_products_image"); ?></th>
                    <th class="pd-y-5"><?= _l("tf_products_item_details"); ?></th>
                    <th class="pd-y-5 tx-right"><?= _l("tf_products_sold"); ?></th>
                    <th class="pd-y-5"><?= _l("tf_products_gain"); ?></th>
                    <th class="pd-y-5 tx-center"></th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(item, $index) in list" :key="$index" :index="$index" :item="item">
                    <td class="pd-l-20">
                        <img :src="item.image" class="wd-55" alt="Image">
                    </td>
                    <td>
                        <a href="" class="tx-inverse tx-14 tx-medium d-block" v-html="item.description"></a>
                        <span class="tx-11 d-block" v-if="item.total_stock"><span class="square-8 bg-danger mg-r-5 rounded-circle"></span> <span v-text="item.total_stock"></span> <?= _l("remaining"); ?></span>
                    </td>
                    <td class="valign-middle tx-right" v-text="item.total_sold"></td>

                    <td class="valign-middle" v-if="item.delta && item.delta > 0">
              <span class="tx-success">
                <i class="icon ion-android-arrow-up mg-r-5"></i>
                <span v-text="item.delta"></span>%
              </span> <?= _l("than_previous"); ?></td>

                    <td class="valign-middle" v-else-if="!item.delta"> -</td>

                    <td class="valign-middle tx-center">
                        <?php /*<a @click.prevent="" class="tx-gray-600 tx-24"><i class="icon ion-android-more-horizontal"></i></a>*/ ?>
                    </td>
                </tr>

                </tbody>
                <tfoot>
                <tr class="tx-10">
                    <td colspan="5">
                        <infinite-loading :identifier="infiniteId" @infinite="infiniteHandler" spinner="bubbles">
                            <div slot="no-more"></div>
                            <div slot="no-results"></div>
                            <!--<div slot="spinner">Loading...</div>
                            <div slot="no-more">No more results</div>
                            <div slot="no-results">No results to display</div>
                            <div slot="error" slot-scope="{ trigger }">
                            An error occured, click <a href="javascript:;" @click="trigger">here</a> to retry
                            </div-->

                        </infinite-loading>
                    </td>
                </tr>
                </tfoot>
            </table>


        </div>
    </template>
    <template id="table_customer_sales">
        <div>

            <table class="table table-responsive table-430 mg-b-0 tx-12" v-cloak>
                <thead>
                <tr class="tx-10">
                    <th class="wd-10p pd-y-5"><?= _l("tf_customer_sales_firstcol"); ?></th>
                    <th class="pd-y-5"><?= _l("tf_customer_sales_client"); ?></th>
                    <th class="pd-y-5"><?= _l("tf_customer_sales_sales_value"); ?></th>
                    <th class="pd-y-5"><?= _l("tf_customer_sales_count"); ?></th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(item, $index) in list" :key="$index" :index="$index" :item="item">

                    <td class="pd-l-20">
                        <img :src="item.image" class="wd-36 rounded-circle" alt="Image">
                    </td>
                    <td>
                        <a href="" class="tx-inverse tx-14 tx-medium d-block" v-text="item.company"></a>
                        <span class="tx-11 d-block" v-text="item.vat"></span>
                    </td>
                    <td class="tx-12">
                        <span class="square-8 bg-success mg-r-5 rounded-circle"></span>
                        <span v-text="item.total_sales"></span> <span v-text="item.symbol"></span>
                    </td>
                    <td v-text="item.sales_count + ' orders'"></td>
                </tr>

                </tbody>
                <tfoot>
                <tr class="tx-10">
                    <td colspan="5">
                        <infinite-loading :identifier="infiniteId" @infinite="infiniteHandler" spinner="bubbles">
                            <div slot="no-more"></div>
                            <div slot="no-results"></div>
                        </infinite-loading>
                    </td>
                </tr>
                </tfoot>
            </table>

        </div>
    </template>

    <?php show_footer(); ?><?php init_tail(); ?>
    <div>
