<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['dashboard']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content" id="app">
        <team_password></team_password>
    </div>
    <template id="team_password">
        <div>
            <?php hooks()->do_action('before_dashboards_content'); ?>
            <div class="row mb20">
                <div class="col-md-12">
                    <div class="" style="background: white;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12 bgbox">
                                        <div class="col-md-9">
                                            <select class="form-control" name="period_filter" id="period_filter"
                                                    v-model="period_filter" @change="filter_on_change($event)">
                                                <option value="all"><?= _l('filter_alltime'); ?></option>
                                                <option value="30d"><?= _l('filter_period_last_30d'); ?></option>
                                                <option value="t"><?= _l('filter_period_today'); ?></option>
                                                <option value="y"><?= _l('filter_period_yesterday'); ?></option>
                                                <option value="w"><?= _l('filter_period_current_week'); ?></option>
                                                <option value="lw"><?= _l('filter_period_last_week'); ?></option>
                                                <option value="m"><?= _l('filter_period_current_month'); ?></option>
                                                <option value="lm"><?= _l('filter_period_last_month'); ?></option>
                                                <option value="yr"><?= _l('filter_period_current_year'); ?></option>
                                                <option value="lyr"><?= _l('filter_period_last_year'); ?></option>
                                                <option value="p"><?= _l('filter_period_range'); ?></option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <a href="#" class="btn btn-primary d-inline" @click.prevent="filter_on_change"><i
                                                        class="fa fa-refresh"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row" v-if=" period_filter == 'p' ">
                                    <div class="col-md-8">
                                        <vue-datepicker @selected-date="updated"></vue-datepicker>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="bgbox">
                                            <button class="btn btn-primary" @click="filter_on_change()"><?= _l('filter_apply'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row pl-5 pr-5">
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('total_password') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center animate-charcter" v-text="total_password"></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('normal_password') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center animate-charcter" v-text="normal_password"></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('bank_account') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center animate-charcter" v-text="bank_account"></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('credit_card') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center animate-charcter" v-text="credit_card"></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('email') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center animate-charcter" v-text="email"></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('server') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center animate-charcter" v-text="server"></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('software_license') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center animate-charcter" v-text="software_license"></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 p-10 m-0">
                    <div class="dashcard-2">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('tp_shared_information') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__widget1">
                                <h4 class="dashcard__widget1_title text-center animate-charcter" v-text="shared"></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row pl-5 pr-5 mb10">
                <div class="col-md-6 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('password_quantity_by_category') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__chart">
                                <div id="password_quantity_by_category"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 p-10 m-0">
                    <div class="dashcard">
                        <div class="dashcard__header border">
                            <div class="dashcard__header_title"><?= _l('password_total_share_by_type') ?></div>
                            <div class="dashcard__header_right_title"></div>
                        </div>
                        <div class="dashcard__body">
                            <div class="dashcard__chart">
                                <div id="password_total_share_by_type"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row pl-5 pr-5">

                <div class="col-md-6 border-right">
                    <div class="bg-white" style="padding: 30px 30px 10px 30px;">
                        <p class="text-dark text-uppercase bold"><?php echo _l('password_shared_to_you_recently'); ?></p>
                        <table class="table dt-table">
                            <thead>
                            <th><?php echo _l('name') ?></th>
                            <th><?php echo _l('read') ?></th>
                            <th><?php echo _l('write') ?></th>
                            <th><?php echo _l('type') ?></th>
                            </thead>
                            <tbody>
                            <?php foreach ($your_password_shared as $pw) { ?>
                                <tr>
                                    <td>
                                        <?php
                                        echo '<a href="' . admin_url('team_password/view_' . $pw['type'] . '/' . $pw['obj_id']) . '">' . item_name_by_objid($pw['obj_id'], $pw['type']) . '</a>';
                                        ?>
                                    </td>
                                    <td><?php echo _l($pw['r']); ?></td>
                                    <td><?php echo _l($pw['w']); ?></td>
                                    <td><?php echo _l($pw['type']); ?></td>
                                </tr>
                            <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="bg-white" style="padding: 30px 30px 10px 30px;">
                        <p class="text-dark text-uppercase bold"><?php echo _l('password_is_about_to_expire'); ?>
                            <a href="<?php echo admin_url('team_password/report?tab=share_report&ef_time=unexpired'); ?>" class="pull-right">...<?php echo _l('view_all'); ?></a>
                        </p>
                        <table class="table dt-table">
                            <thead>
                            <th><?php echo _l('name'); ?></th>
                            <th><?php echo _l('client'); ?></th>
                            <th><?php echo _l('type'); ?></th>
                            <th><?php echo _l('effective_time'); ?></th>
                            </thead>
                            <tbody>
                            <?php foreach ($password_expire as $pass) { ?>
                                <tr>
                                    <td>
                                        <?php
                                        echo '<a href="' . admin_url('team_password/view_' . $pass['type'] . '/' . $pass['share_id']) . '">' . item_name_by_objid($pass['share_id'], $pass['type']) . '</a>';
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $name = '';
                                        $client_name = '';
                                        if ($pass['client'] != '') {
                                            $contact = $this->team_password_model->get_contact_by_email($pass['client']);
                                        } else {
                                            $contact = '';
                                        }

                                        if ($contact != '') {
                                            $name = $contact->lastname . ' ' . $contact->firstname;
                                            $client_id = get_user_id_by_contact_id($contact->id);
                                            $client_name = get_company_name($client_id);
                                        } else {
                                            $name = $pass['email'];
                                        }

                                        if ($pass['client'] != '') {
                                            echo html_entity_decode($client_name . ' - ' . $name);
                                        } else {
                                            echo html_entity_decode($name);
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php echo _l($pass['type']); ?>
                                    </td>
                                    <td>
                                        <?php echo _dt($pass['effective_time']); ?>
                                    </td>
                                </tr>

                            <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


        </div>
    </template>

    <?php show_footer(); ?><?php init_tail(); ?>
    <div>
