<?php defined('BASEPATH') or exit('No direct script access allowed');
class Development_model extends App_Model
{

  public $table_name = 'marketing_campaigns';

  /**
   * Create new holiday
   *
   * @param array $data
   *
   * @return int
   */
  public function add($data)
  {
    if (is_staff_logged_in()) {
      $data['addedfrom'] = get_staff_user_id();
    }


    $data['start'] = date('Y-m-d', strtotime($data['start']));
    $data['end']   = date('Y-m-d', strtotime($data['end']));

    $this->db->insert(db_prefix() . $this->table_name, $data);

    $id  = $this->db->insert_id();
    $log = 'ID: ' . $id;

    $isStaff = null;
    if (!is_client_logged_in() && is_staff_logged_in()) {
      $log     .= ', From Staff: ' . get_staff_user_id();
      $isStaff = get_staff_user_id();
    }

    log_activity('New Marketing Campaign Created [' . $log . ']', $isStaff);

    return $id;
  }

  /**
   * Update employye informations
   *
   * @param array data
   * @param integer ID
   *
   * @return boolean
   */
  public function update($data, $id)
  {
    $this->db->where('id', $id);

    $data['start'] = date('Y-m-d', strtotime($data['start']));
    $data['end']   = date('Y-m-d', strtotime($data['end']));

    $this->db->update(db_prefix() . $this->table_name, $data);

    if ($this->db->affected_rows() > 0) {

      log_activity('Marketing Campaign Updated [ID: ' . $id . ']');

      return true;
    }

    return false;
  }

  /**
   * Get holiday
   *
   * @param int|null $id
   *
   * @return array
   */
  public function get_languages(){
    $this->db->select('*');
    $this->db->from(db_prefix() . 'languages');
    return $this->db->get()->result_array();
  }

  public function get_translations($id = null)
  {
    $this->db->select('*');
    $this->db->select('tbltranslation_text.id as TextId');
    $this->db->from(db_prefix() . 'translation_text');
    //$this->db->where('text', null);
    $this->db->where('translation_strings.id', (int)$id);
    $this->db->join('languages','languages.id = translation_text.id_language','LEFT');

    $this->db->join('translation_strings','translation_text.id_string = translation_strings.id','LEFT');
    
    $translations =  $this->db->get()->result_array();

    $languages = array_values(array_column( $translations,'system'));
    
    $this->db->select('*');
    $this->db->from(db_prefix() . 'translation_strings');
    $this->db->where('translation_strings.id', (int)$id);
    $string =  $this->db->get()->row_array();

    $db_languages = $this->get_languages();
    foreach($db_languages as $lang){
      if(!in_array($lang['system'],$languages)){
        $translations[] = [
          "id"=>null,
          "id_language"=>$lang['id'],
          "id_string"=>$id,
          "text"=>null,
          "is_duplicate"=>0,
          "iso2"=>$lang['iso2'],
          "en_name"=> $lang['en_name'],
          "code"=> $lang['code'],
          "system"=>$lang['system'],
          "namespace"=>$string['namespace'],
          "context"=> $string['context'],
          "category"=>$string['category'],
          "item"=> $string['item'],
          "description"=>$string['description'],
          "module"=>$string['module'],
          "file"=>$string['file'],
          "TextId"=>null
        ];
      }
    }
    /*if(!in_array('romanian',$languages)){
      $translations[] = [
        "id"=>null,
        "id_language"=>1,
        "id_string"=>$translations[0]['id_string'],
        "text"=>null,
        "is_duplicate"=>0,
        "iso2"=>"RO",
        "en_name"=> "Romanian",
        "code"=> "RO-ro",
        "system"=>"romanian",
        "namespace"=>$translations[0]['namespace'],
        "context"=> $translations[0]['context'],
        "category"=>$translations[0]['category'],
        "item"=> $translations[0]['item'],
        "description"=>$translations[0]['description'],
        "module"=>$translations[0]['module'],
        "file"=>$translations[0]['file'],
        "TextId"=>$translations[0]['TextId']
      ];
    }
    if(!in_array('english',$languages)){
      $translations[] = [
        "id"=>null,
        "id_language"=>2,
        "id_string"=>$translations[0]['id_string'],
        "text"=>null,
        "is_duplicate"=>0,
        "iso2"=>"EN",
        "en_name"=> "English",
        "code"=> "EN-gb",
        "system"=>"english",
        "namespace"=>$translations[0]['namespace'],
        "context"=> $translations[0]['context'],
        "category"=>$translations[0]['category'],
        "item"=> $translations[0]['item'],
        "description"=>$translations[0]['description'],
        "module"=>$translations[0]['module'],
        "file"=>$translations[0]['file'],
        "TextId"=>$translations[0]['TextId']
      ];
    }*/
    return  $translations;
  }
  public function get_string($id){
    $this->db->select('*');
    $this->db->where('translation_strings.id', (int)$id);
    $this->db->from(db_prefix() . 'translation_strings');
    return $this->db->get()->row_array();
  }
  public function get_translation($id_lang,$id_string){
    $this->db->select('*');
    $this->db->where('translation_text.id_string', $id_string);
    $this->db->where('translation_text.id_language', $id_lang);    
    $this->db->from(db_prefix() . 'translation_text');
    return $this->db->get()->row_array();
  }
  public function getAllStrings(){
    $this->db->select('*');
    $this->db->from(db_prefix() . 'translation_strings');
    return $this->db->get()->result_array();
  }


  public function update_strings($data){
    foreach($data['string'] as $id_string => $string){
      foreach($string as $id_lang => $text){
        $db_line = $this->get_translation($id_lang,$id_string);
        if($db_line){
          $this->db->where('id',$db_line['id'])->update('translation_text',['text'=>$text]);
        }else{
          $this->db->insert('translation_text',['text'=>$text,'id_language'=>$id_lang,'id_string'=>$id_string]);
        }
      }
    }
  }


  public function update_item($data,$id){
    if(isset($data['csrf_token_name'])){ unset($data['csrf_token_name']); }
    $this->db->where('id',$id)->update('translation_strings',$data);


    /*
          $this->db->where('id',$id)->update('translation_strings',[
            'romanian'=>$data['romanian'],
            'english'=>$data['english'],
            'namespace'=>$data['namespace'],
            'context'=>$data['context'],
            'category'=>$data['category'],
            'module'=>$data['module'],

          ]);*/
  
  }
  public function add_item($data){

    $this->db->insert('translation_strings',[
      'item'=>$data['item'],
      'romanian'=>$data['romanian'],
      'english'=>$data['english'],
      'namespace'=>$data['namespace'],
      'context'=>$data['context'],
      'category'=>$data['category'],
      'module'=>$data['module'],

    ]);
    return $this->db->insert_id();

}


  public function getAll()
  {
    $this->db->order_by('start', 'desc');
    return $this->db->get(db_prefix() . $this->table_name)->result_array();
  }

  /**
   * Delete holiday
   *
   * @param int $id
   *
   * @return bool
   */
  public function delete($id)
  {
    $this->db->where('id', (int)$id);
    $this->db->delete(db_prefix() . $this->table_name);

    return $this->db->affected_rows() > 0;
  }

  public function delete_string($id)
  {
    $this->db->where('id', (int)$id);
    $this->db->delete(db_prefix() . 'translation_strings');

    return $this->db->affected_rows() > 0;
  }

    public function get_card($id){
        $this->db->select('*');
        $this->db->where('id', (int)$id);
        $this->db->from(db_prefix() . 'cards_assist');
        return $this->db->get()->row_array();
    }

    public function delete_card($id)
    {
        $this->db->where('id', (int)$id);
        $this->db->delete(db_prefix() . 'cards_assist');

        return $this->db->affected_rows() > 0;
    }

    public function update_card($data,$id){
        if(isset($data['csrf_token_name'])){ unset($data['csrf_token_name']); }
        $data = [
            'short_link'=>trim($data['short_link']),
            'romanian'=>trim($data['romanian']),
            'english'=>trim($data['english']),
            'type_alert'=>trim($data['type_alert']),

        ];
        $this->db->where('id',$id)->update('cards_assist',$data);
    }

    public function add_card($data){

        $this->db->insert('cards_assist',[
            'short_link'=>trim($data['short_link']),
            'romanian'=>trim($data['romanian']),
            'english'=>trim($data['english']),
            'type_alert'=>trim($data['type_alert']),

        ]);
        return $this->db->insert_id();

    }

}
