<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper" >
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['setting']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo form_open_multipart(admin_url('development/edit_card/' . set_value('id', $string['id'] ?? null)),
                                ['id' => 'edit_card', 'class' => 'edit_card']); ?>

                            <div class="row">

                                <div class="col-md-6">
                                    <?php $label = 'short_link'; ?>
                                    <?php echo render_input('short_link', $label, (isset($string['short_link']) ? htmlspecialchars(stripslashes($string['short_link']))   : ''),'text',[],[],'','',false); ?>
                                    <?php echo form_error('short_link', '<div class="error text-danger">', '</div>'); ?>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="type_alert" class="control-label mg-r-10"><?php echo _l('type_alert'); ?></label>
                                        <div class="clearfix"></div>
                                        <label class="rdiobox" style="display: inline-block;">
                                            <input type="radio" name="type_alert" value="success" <?php echo isset($string) && $string['type_alert'] == 'success' ? 'checked' : ''?> >
                                            <span><?php echo _l('success'); ?></span>
                                        </label>
                                        <label class="rdiobox" style="display: inline-block;">
                                            <input type="radio" name="type_alert" value="info" <?php echo isset($string) && $string['type_alert'] == 'info' ? 'checked' : ''?> >
                                            <span><?php echo _l('info'); ?></span>
                                        </label>
                                        <label class="rdiobox" style="display: inline-block;">
                                            <input type="radio" name="type_alert" value="warning" <?php echo isset($string) && $string['type_alert'] == 'warning' ? 'checked' : ''?> >
                                            <span><?php echo _l('warning'); ?></span>
                                        </label>
                                        <label class="rdiobox" style="display: inline-block;">
                                            <input type="radio" name="type_alert" value="danger" <?php echo isset($string) && $string['type_alert'] == 'danger' ? 'checked' : ''?> >
                                            <span><?php echo _l('danger'); ?></span>
                                        </label>
                                    </div>

                                </div>

                                <div class="col-md-12">
                                    <div class="clearfix"></div>
                                </div>
                                <div class="col-md-6">
                                    <?php echo render_textarea('romanian', 'RO', (isset($string['romanian']) ? (stripslashes($string['romanian']))   : ''), ['rows' => 12], [], '', 'hunset tinymce'); ?>
                                    <?php echo form_error('romanian', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col-md-6">
                                    <?php echo render_textarea('english', 'EN', (isset($string['romanian']) ? (stripslashes($string['english']))   : ''), ['rows' => 12], [], '', 'hunset tinymce'); ?>
                                    <?php echo form_error('english', '<div class="error text-danger">', '</div>'); ?>
                                </div>



                            </div>
                            <hr>


                            <div class="pd-15 mt-3 bd-t" style="margin-top:20px;">
                                <button class="btn btn-info" type="submit"> <?php echo _l('save'); ?></button>
                                <a href="<?= admin_url('development/cards'); ?>" class="btn btn-info"><?php echo _l('back'); ?></a>
                            </div>
                            <?php echo form_close(); ?>

                            <div class="alert alert-bordered alert-success">
                                <strong class="d-block d-sm-inline-block-force">Success!</strong> You successfully read this important alert message.
                            </div>

                            <div class="alert alert-bordered alert-info" >
                                <strong class="d-block d-sm-inline-block-force">Info!</strong> This alert needs your attention, but it's not super important.
                            </div>

                            <div class="alert alert-bordered alert-warning">
                                <strong class="d-block d-sm-inline-block-force">Warning!</strong> Better check yourself, you're not looking too good.
                            </div>

                            <div class="alert alert-bordered alert-danger">
                                <strong class="d-block d-sm-inline-block-force">Danger!</strong> Change a few things up and try submitting again.
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>




</body>
</html>
