<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Package - Essential
Version: 1.0.0
*/

define('PACKAGE_ESSENTIAL', 'essential_package');

$CI = &get_instance();

/**
 * Register activation module hook
 */
register_activation_hook(PACKAGE_ESSENTIAL, 'essential_activation_hook');
register_deactivation_hook(PACKAGE_ESSENTIAL, 'essential_deactivation_hook');

hooks()->add_action('app_init', 'essential_init_package');
hooks()->add_action('admin_init', 'essential_init_menu_items');
hooks()->add_action('admin_init', 'essential_set_package');
hooks()->add_action('clients_init', 'essential_init_clients');



function essential_activation_hook()
{
    require_once(__DIR__ . '/activate.php');
}
function essential_deactivation_hook()
{
  require(__DIR__ . '/deactivate.php');
}


/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(PACKAGE_ESSENTIAL, [PACKAGE_ESSENTIAL]);
function essential_init_package(){
  $CI = &get_instance();
  $CI->app_acl->activate_staff();
  $CI->app_acl->activate_messages();
  $CI->app_acl->activate_sales();
  $CI->app_acl->activate_utilities();
  $CI->app_acl->activate_agenda();
  $CI->app_acl->activate_contracts();
  //$CI->app_acl->activate_itcorner();
  $CI->app_acl->custom_fields();
  $CI->app_acl->project_management();
  $CI->app_acl->marketing();
  $CI->app_acl->legal();
  $CI->app_acl->technical_support();
  $CI->app_acl->finance();
  $CI->app_acl->reports();

  //$CI->app_acl->remove_disabled_route();

  //Pro
  $CI->app_acl->disabled_routes[] = 'admin/reports/expenses';
  $CI->app_acl->disabled_routes[] = 'admin/reports/expenses_vs_income';
  $CI->app_acl->disabled_routes[] = 'admin/dashboard/ceo';
  $CI->app_acl->disabled_routes[] = 'admin/dashboard/cmo';
  $CI->app_acl->disabled_routes[] = 'admin/dashboard/inbound_lead_generation';
  $CI->app_acl->disabled_routes[] = 'admin/dashboard/helpdesk';
  $CI->app_acl->disabled_routes[] = 'admin/dashboard/tactical_finance';

  //deactivate PayU|Stripe|Instamoj

  //limit 1Gb pe utilities media

  $CI->app_acl->remove_disabled_route([
    'admin/okr/report',
    'admin/commission/manage_commission',
    'admin/reports/sales',
    'admin/reports/expenses',
    'admin/reports/expenses_vs_income',
    'admin/reports/leads',
    'admin/team_password/report',
    'admin/resource_workload',
    'admin/staff/timesheets',
    'admin/reports/export_customer',
    'admin/reports/knowledge_base_articles',
    //'leads'
  ]);
  //$CI->app_acl->do_blocked_routes();

}



function essential_init_clients(){

  essential_init_menu_items();

}
/**
 * Init menu setup module menu items in setup in admin_init hook
 * @return null
 */
function essential_init_menu_items()
{
    $CI = &get_instance();
    if (is_admin()) {


    }







}

function essential_set_package(){
  $CI = &get_instance();


  hooks()->do_action('package_loaded');

}


// return status book
if(!DEFINED('MEMBERS_INCLUDED')){
DEFINE('MEMBERS_INCLUDED',5);
}
hooks()->add_filter('before_staff_status_change', 'ess_max_members', 10, 2);
function ess_max_members($status, $id){
  $CI = &get_instance();

  $max_active_members = MEMBERS_INCLUDED + (int)get_option('extra_seats');
  if((int)$status == 1){
    if((int)$CI->staff_model->count_active_members() >= $max_active_members AND $max_active_members != 0){
      return 0;
    }else{
      return 1;
    }
  }else{
    return 0;
  }


}
