<?php defined('BASEPATH') or exit('No direct script access allowed');

class Awards extends AdminController
{

  public function __construct()
  {
    parent::__construct();

    $this->load->model('employees_model');
    $this->load->model('awards_model');
    $this->load->model('award_types_model');

  }

  public function index(){

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }

    $data['title'] = _l('hr_awards');

    $this->load->view('awards/manage', $data);
  }
  public function types(){

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }

    $data['title'] = _l('hr_award_types');

    $this->load->view('awards/manageTypes', $data);
  }
  public function create($id = ''){

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }


    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();

      if (!$id) {
        if (!has_permission('hr_employees', '', 'create')) {
          access_denied('hr_employees');
        }

        $id = $this->awards_model->add($data);

        if ($id) {
          add_file($id, 'img', HR_UPLOAD_AWARD_REAL, 'hr_awards', 'img');
          set_alert('success', _l('added_successfully', _l('employee')));
        }
      } else {
        if (!has_permission('hr_employees', '', 'edit')) {
          access_denied('hr_employees');
        }

        $success = $this->awards_model->update($data, $id);
        add_file($id, 'img', HR_UPLOAD_AWARD_REAL, 'hr_awards', 'img');

        if ($success == true) {

          set_alert('success', _l('updated_successfully', _l('employee')));
        }
      }

      redirect(admin_url('hr/awards/create/' . $id));
    }

    $award = null;

    if ($id) {
      $award = $this->awards_model->get($id);

      if (!$award) {
        show_404();
      }
    }

    $data['award']     = $award;
    if ($award){
        $data['title'] = _l('hr_edit_award');
    }else{
        $data['title'] = _l('hr_new_award');
    }


    $data['employees'] = $this->employees_model->get(0);;
    $data['types'] = $this->award_types_model->get(0);;

    $this->load->view('awards/create', $data);
  }

  public function removeImg($id = 0){
    $award = $this->awards_model->get((int)$id);

    if (!$award) {
      show_404();
    }

    if (is_file(HR_UPLOAD_AWARD_REAL . $award->img)) {
      unlink(HR_UPLOAD_AWARD_REAL . $award->img);
    }

    $this->db->query("UPDATE " . db_prefix() . "hr_awards SET img=null WHERE id={$id}");

    redirect(admin_url('hr/awards/create/' . $id));
  }

  public function createType($id = ''){

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }
    $data['title'] = _l('hr_award_type');
    if ($this->input->post()) {
      $data = $this->input->post();

      if (!$id) {
        if (!has_permission('hr_employees', '', 'create')) {
          access_denied('hr_employees');
        }

        $id = $this->award_types_model->add($data);

        if ($id) {
          set_alert('success', _l('added_successfully', _l('employee')));
        }
      } else {
        if (!has_permission('hr_employees', '', 'edit')) {
          access_denied('hr_employees');
        }

        $success = $this->award_types_model->update($data, $id);
        if ($success == true) {
          set_alert('success', _l('updated_successfully', _l('employee')));
        }
      }

      if (!$this->input->is_ajax_request()) {
        redirect(admin_url('hr/awards/createType/' . $id));
      }
    }

    $type          = null;
    $data['error'] = 0;

    if ($id) {
      $type = $this->award_types_model->get($id);

      if (!$type) {
        if ($this->input->is_ajax_request()) {
          $data['error'] = 1;
        } else {
          show_404();
        }
      }
    }

    $data['type'] = $type;

    if ($this->input->is_ajax_request()) {
        if($data['error'] == 1){
            echo json_encode($data);
            die();
        }else{
            $this->load->view('modals/min/award-type',$data);
        }
    }else{
        $this->load->view('awards/createType',$data);
    }


  }

  public function table_awards(){
    if (!has_permission('hr', '', 'view')) {
      access_denied('hr_employees');
    }

    $aColumns = [
      db_prefix() . 'hr_awards.id as award_id',
      db_prefix() . 'hr_awards.name as name',
      'gift',
      'cash',
      'date',
      '(CASE WHEN ISNULL(staffid) THEN CONCAT(COALESCE('.db_prefix().'hr_employees.firstname)," ", COALESCE('.db_prefix().'hr_employees.lastname)) ELSE CONCAT(COALESCE('.db_prefix().'staff.firstname)," ", COALESCE('.db_prefix().'staff.lastname)) END
        ) as fullname',
      db_prefix() . 'hr_award_types.name as type_name',
    ];

    $join = [
      'LEFT JOIN ' . db_prefix() . 'staff ON ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'hr_awards.user_id',
      'LEFT JOIN ' . db_prefix() . 'hr_employees ON ' . db_prefix() . 'hr_employees.id_staff = ' . db_prefix() . 'staff.staffid',
      //'LEFT JOIN ' . db_prefix() . 'hr_employees ON ' . db_prefix() . 'hr_employees.id = ' . db_prefix() . 'hr_awards.user_id',
      'LEFT JOIN ' . db_prefix() . 'hr_award_types ON ' . db_prefix() . 'hr_awards.award_type_id = ' . db_prefix() . 'hr_award_types.id',
    ];

    $sIndexColumn = 'id';
    $sTable       = db_prefix() . 'hr_awards';

    $where  = [];
    $filter = [];

    if (count($filter) > 0) {
      array_push($where, 'AND (' . prepare_dt_filter($filter) . ')');
    }

    $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [db_prefix() . 'hr_employees.id']);
    $output  = $result['output'];
    $rResult = $result['rResult'];

    foreach ($rResult as $aRow) {
      $row = [];

      $row[]  = $aRow['name'];
      $row[]  = $aRow['fullname'];
      $row[]  = $aRow['type_name'];
      $row[]  = $aRow['gift'];
      $row[]  = round($aRow['cash'],2);
      $row[]  = $aRow['date'];
      $action
              = '<a type="button" class="btn btn-sm btn-outline-secondary" href="' . admin_url('hr/awards/create/' . $aRow['award_id']) . '"><i class="fal fa-edit"></i></a>';
      $action .= '<a type="button" class="btn btn-sm btn-outline-danger mg-l-5" href="' . admin_url('hr/awards/remove/' . $aRow['award_id']) . '"><i class="fal fa-trash text-danger"></i></a>';

      $row[]              = $action;
      $output['aaData'][] = $row;
    }

    echo json_encode($output);
    die();
  }
  public function table_awardTypes(){
    if (!has_permission('hr', '', 'view')) {
      access_denied('hr_employees');
    }

    $aColumns = [
      //db_prefix() . 'hr_award_types.id as awardType_id',
      db_prefix() . 'hr_award_types.name as name',
      db_prefix() . 'hr_award_types.description as description',
    ];

    $join = [];

    $sIndexColumn = 'id';
    $sTable       = db_prefix() . 'hr_award_types';

    $where  = [];
    $filter = [];

    if (count($filter) > 0) {
      array_push($where, 'AND (' . prepare_dt_filter($filter) . ')');
    }

    $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [db_prefix() . 'hr_award_types.id as awardType_id']);
    $output  = $result['output'];
    $rResult = $result['rResult'];

    foreach ($rResult as $aRow) {
      $row = [];

      $row[]  = $aRow['name'];
      $row[]  = $aRow['description'];
      $action
              = '<a type="button" class="btn btn-sm btn-outline-secondary" href="' . admin_url('hr/awards/createType/' . $aRow['awardType_id']) . '"><i class="fal fa-edit"></i></a>';
      $action .= '<a type="button" class="btn btn-sm btn-outline-danger mg-l-5" href="' . admin_url('hr/awards/removeType/' . $aRow['awardType_id']) . '"><i class="fal fa-trash text-danger"></i></a>';

      $row[]              = $action;
      $output['aaData'][] = $row;
    }

    echo json_encode($output);
    die();
  }


  public function remove($id = 0){
    $award = $this->awards_model->get((int)$id);

    if (!$award) {
      show_404();
    }

    if (is_file(HR_UPLOAD_AWARD_REAL . $award->img)) {
      unlink(HR_UPLOAD_AWARD_REAL . $award->img);
    }

    $success = $this->awards_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('awards')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('awards')));
    }

    redirect(admin_url('hr/awards/'));
  }
  public function removeType($id = 0){
    $type = $this->award_types_model->get((int)$id);

    if (!$type) {
      show_404();
    }


    $success = $this->award_types_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('hr_award_type')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_award_type')));
    }

    redirect(admin_url('hr/awards/types/'));
  }
}
