<?php defined('BASEPATH') or exit('No direct script access allowed');

class Company extends AdminController
{

  public function __construct()
  {
    parent::__construct();

    $this->load->model('employees_model');
    $this->load->model('departments_hr_model');
    $this->load->model('locations_model');
    $this->load->model('designations_hr_model');

    $this->load->helper(['form', 'url']);
    $this->load->library('form_validation');
  }

  public function index()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }


    $data['title'] = _l('hr_departments');
    $this->load->view('company/manage', $data);
  }

  public function createDepartment($id = null)
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }


    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->reset_validation();

      $this->form_validation->set_rules('name', _l('name'), 'required');
      $this->form_validation->set_rules('user_id', _l('hr_department_head'), 'required');
      $this->form_validation->set_rules('location_id', _l('hr_location'), 'required');

      if($this->form_validation->run() === true){
        if (!$id) {
          if (!has_permission('hr_employees', '', 'create')) {
            access_denied('hr_employees');
          }

          $id = $this->departments_hr_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('employee')));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->departments_hr_model->update($data, $id);

          if ($success == true) {

            set_alert('success', _l('updated_successfully', _l('employee')));
          }
        }
        redirect(admin_url('hr/company/createDepartment/' . $id));
      }
    }

    $department = null;

    if ($id) {
      $department = $this->departments_hr_model->get($id);

      if (!$department) {
        show_404();
      }
    }

    $data = (array)$department;

    if ($id){
      $data['title'] = _l('hr_edit_department');
    }else{
      $data['title'] = _l('hr_new_department');
    }



    $data['id'] = $id;

    $data['employees']  = $this->employees_model->get(0);
    $data['locations']  = $this->locations_model->get(0);

    $this->load->view('company/createDepartment', $data);
  }

  public function removeDempartment($id)
  {
    $department = $this->departments_hr_model->get($id);

    if (!$department) {
      show_404();
    }

    if ($this->departments_hr_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('deparments')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('deparments')));
    }

    redirect(admin_url('hr/company/'));
  }

  public function locations()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }

    $data['title'] = _l('hr_locations');

    $this->load->view('company/locations', $data);
  }

  public function createLocation($id = '')
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->reset_validation();

      //var_dump($_POST); exit;
      $this->form_validation->set_rules('name', _l('name'), 'required');
      $this->form_validation->set_rules('user_id', _l('hr_department_head'), 'required');

      if($this->form_validation->run() === true){
        if (!$id) {
          if (!has_permission('hr_employees', '', 'create')) {
            access_denied('hr_employees');
          }

          $id = $this->locations_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', ucfirst(_l('location'))));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->locations_model->update($data, $id);

          if ($success == true) {

            set_alert('success', _l('updated_successfully', _l('employee')));
          }
        }
        redirect(admin_url('hr/company/locations'));
        //redirect(admin_url('hr/company/createLocation/' . $id));
      }
    }

    $location = null;

    if ($id) {
      $location = $this->locations_model->get($id);

      if (!$location) {
        show_404();
      }
    }

    $data = (array)$location;
    $data['title'] = _l('hr_new_location');
    $data['employees'] = $this->employees_model->get(0);

    $this->load->view('company/createLocation', $data);
  }

  public function removeLocation($id)
  {
    $location = $this->locations_model->get($id);

    if (!$location) {
      show_404();
    }

    if ($this->locations_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('hr_location')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_location')));
    }

    redirect(admin_url('hr/company/locations'));
  }


  public function designations()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }

    $data['title'] = _l('hr_designations');

    $this->load->view('company/designations', $data);
  }

  public function createDesignation($id = '')
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->reset_validation();

      $this->form_validation->set_rules('name', _l('name'), 'required');
      if($this->form_validation->run() === true){
        if (!$id) {
          if (!has_permission('hr_employees', '', 'create')) {
            access_denied('hr_employees');
          }

          $id = $this->designations_hr_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('designation')));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->designations_hr_model->update($data, $id);

          if ($success == true) {

            set_alert('success', _l('updated_successfully', _l('designation')));
          }
        }
        redirect(admin_url('hr/company/designations'));
      }
    }

    $designation = null;

    if ($id) {
      $designation = $this->designations_hr_model->get($id);

      if (!$designation) {
        show_404();
      }
    }

    $data = (array)$designation;
    $data['title'] = _l('Create location');

    $this->load->view('company/createDesignation', $data);
  }

  public function removeDesignation($id)
  {
    $designation = $this->designations_hr_model->get($id);

    if (!$designation) {
      show_404();
    }

    if ($this->designations_hr_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('designation')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('designation')));
    }

    redirect(admin_url('hr/company/designations'));
  }


}
