<?php defined('BASEPATH') or exit('No direct script access allowed');

class Documents extends AdminController
{

  public function __construct()
  {
    parent::__construct();

    $this->load->model('employees_model');
    $this->load->model('departments_hr_model');
    $this->load->model('documents_model');
    $this->load->model('document_types_model');
    $this->load->model('document_categories_model');

    $this->load->helper(['form', 'url']);
    $this->load->library('form_validation');

  }

  public function index()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }

    $data = [];
    $data['title'] = _l('hr_documents');
    $this->load->view('documents/manage', $data);
  }

  public function create($id = '')
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->set_rules('name', _l('name'), 'required');
      $this->form_validation->set_rules('number', _l('number'), 'required');

      if($id == ''){
      if (empty($_FILES['file']['name'])) {
        $this->form_validation->set_rules('file', _l('hr_document'), 'required');
      }}

      if ($this->form_validation->run() === true) {
        if (!$id) {
          if (!has_permission('hr_employees', '', 'create')) {
            access_denied('hr_employees');
          }

          if(!empty($_FILES['file']['name'])){
            $data['original_filename'] = $_FILES['file']['name'];
          }
          $id = $this->documents_model->add($data);

          if ($id) {
            add_file($id, 'file', HR_UPLOAD_DOCUMENT_REAL, 'hr_documents', 'filename', 'document-' . $id);
            set_alert('success', _l('added_successfully', _l('employee')));
          }
        } else {

          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }
          $success = $this->documents_model->update($data, $id);
          add_file($id, 'file', HR_UPLOAD_DOCUMENT_REAL, 'hr_documents', 'filename', 'document-' . $id);

          if ($success == true) {

            set_alert('success', _l('updated_successfully', _l('employee')));


          }

        }

        redirect(admin_url('hr/documents/create/' . $id));
      }
    }

    $document = null;

    if ($id) {
      $document = $this->documents_model->get($id);

      if (!$document) {
        show_404();
      }
    }

    $data    = (array)$document;
    if(!isset($data['id'])) $data['id'] = 0;

    if (set_value('id', $data['id'] ?? 0)){
      $data['title'] = _l('hr_edit_document');
    }else{
      $data['title'] = _l('hr_new_document');
    }

    $data['employees']   = $this->employees_model->get(0);
    $data['types']       = $this->document_types_model->getAll();
    $data['categories']  = $this->document_categories_model->getAll();
    $data['departments'] = $this->departments_hr_model->get(0);

    $this->load->view('documents/create', $data);
  }

  public function download($id = '')
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $document = $this->documents_model->get($id);

    if (!$document) {
      show_404();
    }

    $this->load->helper('download');


    if (!is_file(HR_UPLOAD_DOCUMENT_REAL . $document->filename)) {
      set_alert('warning', _l('hr_document_not_uploaded', _l('employee')));
      redirect(admin_url('hr/documents/create/' . $id));
    }

    force_download(HR_UPLOAD_DOCUMENT_REAL . $document->filename, null);
  }

  public function removeImg($id = 0)
  {
    $award = $this->awards_model->get((int)$id);

    if (!$award) {
      show_404();
    }

    if (is_file(HR_UPLOAD_AWARD_REAL . $award->img)) {
      unlink(HR_UPLOAD_AWARD_REAL . $award->img);
    }

    $this->db->query("UPDATE " . db_prefix() . "hr_awards SET img=null WHERE id={$id}");

    redirect(admin_url('hr/awards/create/' . $id));
  }

  public function remove($id = 0)
  {
    $document = $this->documents_model->get((int)$id);

    if (!$document) {
      show_404();
    }

    if (is_file(HR_UPLOAD_DOCUMENT_REAL . $document->filename)) {
      unlink(HR_UPLOAD_DOCUMENT_REAL . $document->filename);
    }

    $success = $this->documents_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('document')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('document')));
    }

    redirect(admin_url('hr/documents/'));
  }

  public function categories()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }
    $data['title'] = _l('categories');
    $this->load->view('documents/manageCategories', $data);
  }

  public function createCategory($id = null)
  {
    $id = $this->input->post('id');
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post()) {
      $data = $this->input->post();

      if (!$id) {
        $id = $this->document_categories_model->add($data);

        if ($id) {
          set_alert('success', _l('added_successfully', _l('employee')));
        }

      } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }
          //$id = $this->input->post('id');
            $success = $this->document_categories_model->update($data, $id);
        if ($success == true) {
          set_alert('success', _l('updated_successfully', _l('employee')));
        }
        redirect(admin_url('hr/documents/'));
      }

      if (!$this->input->is_ajax_request()) {
        redirect(admin_url('hr/documents/createCategory/' . $id));
      }
    }


    $category          = null;
    $data['error'] = 0;

    if ($id) {
      $category = $this->document_categories_model->get($id);

      if (!$category) {
        if ($this->input->is_ajax_request()) {
          $data['error'] = 1;
        } else {
          show_404();
        }
      }
    }

    $data['category'] = $category;
    $data['title'] = _l('create_document_category');
    if ($this->input->is_ajax_request()) {
        if($data['error'] == 1){
            echo json_encode($data);
            die();
        }else{
            $this->load->view('modals/min/documents-category',$data);
        }
    }else{
        $this->load->view('documents/createCategory',$data);
    }


  }

  public function getCategory()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $category = $this->document_categories_model->get($this->input->post('id', true));

    if (!$category) {
      ajax_error(_l('error'));
    }

    _ok_response(['status' => 1, 'category' => $category]);
  }

  public function removeCategory($id = 0)
  {
    $category = $this->document_categories_model->get((int)$id);

    if (!$category) {
      show_404();
    }

    $success = $this->document_categories_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('categories')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('categories')));
    }

    redirect(admin_url('hr/documents/categories'));
  }

  public function types()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }
    $data['title'] = _l('types');
    $this->load->view('documents/manageTypes', $data);
  }

  public function createType($id = null)
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }



    if ($this->input->post()) {
      //$id = (int)$this->input->post('id', true);
      $data = $this->input->post();

      if (!$id) {
        //$id = $this->input->post('id');
        $id = $this->document_types_model->add($data);

        if ($id) {
          set_alert('success', _l('added_successfully', _l('employee')));
        }

      } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }
          //$id = $this->input->post('id');
            $success = $this->document_types_model->update($data, $id);
        if ($success == true) {
          set_alert('success', _l('updated_successfully', _l('employee')));
        }
      }

      if (!$this->input->is_ajax_request()) {
        redirect(admin_url('hr/documents/createType/' . $id));
      }
    }


    $type          = null;
    $data['error'] = 0;

    if ($id) {
      $type = $this->document_types_model->get($id);

      if (!$type) {
        if ($this->input->is_ajax_request()) {
          $data['error'] = 1;
        } else {
          show_404();
        }
      }
    }

    $data['type'] = $type;
    $data['title'] = _l('create_document_type');
    if ($this->input->is_ajax_request()) {
        if($data['error'] == 1){
            echo json_encode($data);
            die();
        }else{
            $this->load->view('modals/min/documents-type',$data);
        }
    }else{
        $this->load->view('documents/createType',$data);
    }



  }

  public function getType()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $type = $this->document_types_model->get($this->input->post('id', true));

    if (!$type) {
      ajax_error(_l('error'));
    }

    _ok_response(['status' => 1, 'type' => $type]);
  }

  public function removeType($id = 0)
  {
    $type = $this->document_types_model->get((int)$id);

    if (!$type) {
      show_404();
    }

    $success = $this->document_types_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('categories')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('categories')));
    }

    redirect(admin_url('hr/documents/types'));
  }

  public function expired()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }

    $data = [];
    $data['title'] = _l('hr_expire_documents');
    $this->load->view('documents/manageExpired', $data);
  }
}
