<?php defined('BASEPATH') or exit('No direct script access allowed');

class Employee extends AdminController
{

  public function __construct()
  {
    parent::__construct();

    $this->load->model('employees_model');
    $this->load->model('locations_model');
    $this->load->model('departments_hr_model');
    $this->load->model('transfers_hr_model');
    $this->load->model('resignations_model');
    $this->load->model('promotions_hr_model');
    $this->load->model('designations_hr_model');
    $this->load->model('complaints_hr_model');
    $this->load->model('warnings_hr_model');
    $this->load->model('terminations_model');
    $this->load->model('shifts_model');
    $this->load->model('shift_days_model');
    $this->load->model('termination_types_model');

    $this->load->helper(['form', 'url']);
    $this->load->library('form_validation');
  }

  public function index()
  {
    if (!has_permission('hr_employees', '', 'view')) {
        access_denied('hr_employees');
    }
    $data = [];
    $data['title'] = _l('hr_employees');
    $this->load->view('employees/manage', $data);
  }

  public function profile($id = '')
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $employee    = null;
    $departments = [];
    if ($id) {
      $employee = $this->employees_model->get($id);

      if (!$employee) {
        show_404();
      }

      $departments = $this->departments_hr_model->getByLocation((int)$employee->location_id);
    }

    $data['employee']    = $employee;
    $data['employees']   = $this->employees_model->getWithout($id);
    $data['locations']   = $this->locations_model->get(0);
    $data['shifts']      = $this->shifts_model->get(0);
    $data['departments'] = $departments;

    $data['title'] = _l('hr_employee_profile');

    $this->load->view('employees/profile', $data);
  }

  public function createEmployee($id = null)
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();

      if (!$id) {
        if (!has_permission('hr_employees', '', 'create')) {
          access_denied('hr_employees');
        }

        $id = $this->employees_model->add($data);

        if ($id) {
          set_alert('success', _l('added_successfully', _l('employee')));
        }
      } else {
        if (!has_permission('hr_employees', '', 'edit')) {
          access_denied('hr_employees');
        }

        $success = $this->employees_model->update($data, $id);
        if ($success == true) {
          set_alert('success', _l('updated_successfully', _l('employee')));
        }
      }

      redirect(admin_url('hr/employee/createEmployee/' . $id));
    }

    $employee    = null;
    $departments = [];
    $this->load->model('departments_model');
    $departments = $this->departments_model->get();

    if ($id) {
      $employee = $this->employees_model->get($id);

      if (!$employee) {
        show_404();
      }


    }

    $data['employee']    = $employee;
    $data['employees']   = $this->employees_model->getWithout($id);
    $data['locations']   = $this->locations_model->get(0);
    $data['shifts']      = $this->shifts_model->get(0);
    $data['departments'] = $departments;

    if ($data['employee']){
      $data['title'] = _l('hr_edit_employee');
    }else{
      $data['title'] = _l('hr_new_employee');
    }

    $this->load->view('employees/create', $data);
  }
  public function removeEmployee($id)
  {
      $employee = $this->employees_model->get($id);

      if (!$employee) {
        show_404();
      }

    if ($this->employees_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('hr_employee')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_employee')));
    }

    redirect(admin_url('hr/employee'));
  }

  public function getDeparments()
  {
    $options     = '<option value=""></option>';
    $departments = $this->departments_hr_model->getByLocation((int)$this->input->post('location_id', true));

    foreach ($departments as $department) {
      $options .= '<option value="' . $department['id'] . '">' . $department['name'] . '</option>';
    }

    die($options);
  }

  public function transfers()
  {
    if (!has_permission('hr_employees', '', 'view')) {
              access_denied('hr_employees');
    }
    $data = [];
    $data['title'] = _l('hr_transfers');
    $this->load->view('employees/transfers', $data);
  }

  public function createTransfer($id = null)
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }


    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data        = $this->input->post();

      $this->form_validation->set_rules('user_id', _l('hr_department_head'), 'required');
      $this->form_validation->set_rules('location_id', _l('hr_location'), 'required');
      $this->form_validation->set_rules('department_id', _l('hr_location'), 'required');
      $this->form_validation->set_rules('date', _l('hr_location'), 'required');

      if ($this->form_validation->run() === true) {

        if (!$id) {
          if (!has_permission('hr_employees', '', 'create')) {
            access_denied('hr_employees');
          }

          $id = $this->transfers_hr_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('hr_transfer')));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->transfers_hr_model->update($data, $id);
          if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('hr_transfer')));
          }
        }

        redirect(base_url('hr/employee/createTransfer/' . $id));
      }
    }

    $transfer    = null;
    if ($id) {
      $transfer = $this->transfers_hr_model->get($id);

      if (!$transfer) {
        show_404();
      }
    }

    $data = (array)$transfer;

    //if (isset($data['id'])) $data['id'] = 0;

    $data['employees']   = $this->employees_model->get(0);
    $data['locations']   = $this->locations_model->get(0);
    $data['departments'] = $this->departments_hr_model->get(0);
    if (!set_value('id', $data['id'] ?? 0)){
      $data['title'] = _l('hr_edit_transfer');
    }else{
      $data['title'] = _l('hr_new_transfer');
    }


    $this->load->view('employees/createTransfer', $data);
  }

  public function removeTransfer($id)
  {
    $transfer = $this->transfers_hr_model->get($id);

    if (!$transfer) {
      show_404();
    }

    if ($this->transfers_hr_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('hr_transfer')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_transfer')));
    }

    redirect(admin_url('hr/employee/transfers'));
  }

  public function resignations()
  {
    if (!has_permission('hr_employees', '', 'view')) {
              access_denied('hr_employees');
    }
    $data = [];
    $data['title'] = _l('hr_resignations');
    $this->load->view('employees/resignations', $data);
  }

  public function createResignation($id = 0)
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->set_rules('user_id', _l('hr_department_head'), 'required');
      $this->form_validation->set_rules('date', _l('hr_date_notice'), 'required');
      $this->form_validation->set_rules('date_resignation', _l('hr_date_resignation'), 'required');
      if ($this->form_validation->run() === true) {
        if (!$id) {
          if (!has_permission('hr_employees', '', 'create')) {
            access_denied('hr_employees');
          }

          $id = $this->resignations_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('hr_resignation')));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->resignations_model->update($data, $id);
          if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('hr_resignation')));
          }
        }

        redirect(admin_url('hr/employee/createResignation/' . $id));
      }
    }

    $resignation = null;
    if ($id) {
      $resignation = $this->resignations_model->get($id);

      if (!$resignation) {
        show_404();
      }
    }
    $data = (array)$resignation;
    //if (isset($data['id'])) $data['id'] = 0;

    $data['employees']   = $this->employees_model->get(0);

    if (!set_value('id', $data['id'] ?? 0)){
      $data['title'] =  _l('hr_edit_resignation');
    }else{
      $data['title'] = _l('hr_new_resignation');
    }

    $this->load->view('employees/createResignation', $data);
  }

  public function removeResignation($id)
  {
    $resignation = $this->resignations_model->get($id);

    if (!$resignation) {
      show_404();
    }

    if ($this->resignations_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('hr_resignations')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_resignations')));
    }

    redirect(admin_url('hr/employee/resignations'));
  }

  public function promotions()
  {
    if (!has_permission('hr_employees', '', 'view')) {
        access_denied('hr_employees');
    }
    $data = [];
    $data['title'] = _l('hr_promotions');
    $this->load->view('employees/promotions', $data);
  }

  public function createPromotion($id = 0)
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->set_rules('user_id', _l('hr_employee'), 'required', array('required' => _l('form_validation_required')));
      $this->form_validation->set_rules('designation_id', _l('designation'), 'required', array('required' => _l('form_validation_required')));
      $this->form_validation->set_rules('title', _l('hr_title'), 'required', array('required' => _l('form_validation_required')));
      $this->form_validation->set_rules('date', _l('date'), 'required', array('required' => _l('form_validation_required')));

      if ($this->form_validation->run() === true) {
        if (!$id) {
          if (!has_permission('hr_employees', '', 'create')) {
            access_denied('hr_employees');
          }

          $id = $this->promotions_hr_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('hr_promotion')));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->promotions_hr_model->update($data, $id);
          if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('hr_promotion')));
          }
        }

        redirect(admin_url('hr/employee/createPromotion/' . $id));
      }
    }

    $promotion = null;
    if ($id) {
      $promotion = $this->promotions_hr_model->get($id);

      if (!$promotion) {
        show_404();
      }
    }

    $data = (array)$promotion;
    if(!isset($data['id'])) $data['id'] = 0;

    $data['employees'] = $this->employees_model->get(0);

    if (set_value('id', $id ?? 0)){
      $data['title'] = _l('hr_edit_promotion');
    }else{
      $data['title'] = _l('hr_new_promotion');
    }


    $this->load->view('employees/createPromotion', $data);
  }

  public function removePromotion($id)
  {
    $promotion = $this->promotions_hr_model->get($id);

    if (!$promotion) {
      show_404();
    }

    if ($this->promotions_hr_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('hr_promotions')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_promotions')));
    }

    redirect(admin_url('hr/employee/promotions'));
  }

  public function complaints()
  {
    if (!has_permission('hr_employees', '', 'view')) {
              access_denied('hr_employees');
    }
    $data = [];
    $data['title'] = _l('hr_complaints');
    $this->load->view('employees/complaints', $data);
  }

  public function createComplaint($id = 0)
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->set_rules('from_user_id', _l('hr_from_employee'), 'required');
      $this->form_validation->set_rules('user_id', _l('hr_to_employee'), 'required');
      $this->form_validation->set_rules('title', _l('hr_title'), 'required');
      $this->form_validation->set_rules('date', _l('date'), 'required');

      if ($this->form_validation->run() === true) {
        if (!$id) {
          $id = $this->complaints_hr_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('hr_complaint')));
            redirect(admin_url('hr/employee/createComplaint/' . $id));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->complaints_hr_model->update($data, $id);
          if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('hr_complaint')));
            redirect(admin_url('hr/employee/complaints'));
          }
        }


      }
    }

    $complaint = null;
    if ($id) {
      $complaint = $this->complaints_hr_model->get($id);

      if (!$complaint) {
        show_404();
      }
    }

    $data = (array)$complaint;
    if(!isset($data['id'])) $data['id'] = 0;
    $data['employees'] = $this->employees_model->get(0);
    if (set_value('id', $data['id'] ?? 0)){
      $data['title'] = _l('hr_edit_complaint');
    }else{
      $data['title'] =  _l('hr_new_complaint');
    }

    $this->load->view('employees/createComplaint', $data);
  }
  public function viewComplaint($id = null){
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $complaint = null;
    if ($id) {
      $complaint = $this->complaints_hr_model->get($id);

      if (!$complaint) {
        show_404();
      }
    }

    $data = (array)$complaint;
    $data['page_title'] = _l('hr_view_complaint');

    $this->load->view('employees/viewComplaint', $data);
  }


  public function removeComplaint($id)
  {
    $complaint = $this->complaints_hr_model->get($id);

    if (!$complaint) {
      show_404();
    }

    if ($this->complaints_hr_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('hr_complaints')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_complaints')));
    }

    redirect(admin_url('hr/employee/complaints'));
  }

  public function warnings()
  {
    if (!has_permission('hr_employees', '', 'view')) {
        access_denied('hr_employees');
    }
    $data = [];
    $data['title'] = _l('hr_warnings');
    $this->load->view('employees/warnings', $data);
  }

  public function createWarning($id = 0)
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->set_rules('from_user_id', _l('hr_from_employee'), 'required');
      $this->form_validation->set_rules('user_id', _l('hr_to_employee'), 'required');
      $this->form_validation->set_rules('title', _l('hr_title'), 'required');
      $this->form_validation->set_rules('date', _l('date'), 'required');

      if ($this->form_validation->run() === true) {
        if (!$id) {
          if (!has_permission('hr_employees', '', 'create')) {
            access_denied('hr_employees');
          }

          $id = $this->warnings_hr_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('hr_warning')));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->warnings_hr_model->update($data, $id);
          if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('hr_warning')));
          }
        }

        redirect(admin_url('hr/employee/createWarning/' . $id));
      }
    }

    $warning = null;
    if ($id) {
      $warning = $this->warnings_hr_model->get($id);
      $data   = (array)$warning;
      $data['wtitle'] = $warning->title;
      if (!$warning) {
        show_404();
      }
    }else{

    }


    //if(!isset($data['id'])) $data['id'] = 0;

    $data['employees'] = $this->employees_model->get(0);
    if (!set_value('id', $data['id'] ?? 0)){
      $data['title'] = _l('hr_edit_warning');
    }else{
      $data['title'] = _l('hr_new_warning');
    }

    $this->load->view('employees/createWarning', $data);
  }
  public function viewWarning($id = null){
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $warning = null;
    if ($id) {
      $warning = $this->warnings_hr_model->get($id);

      if (!$warning) {
        show_404();
      }
    }

    $data = (array)$warning;
    $data['page_title'] = _l('hr_view_warning');

    $this->load->view('employees/viewWarning', $data);
  }
  public function removeWarning($id)
  {
    $warning = $this->warnings_hr_model->get($id);

    if (!$warning) {
      show_404();
    }

    if ($this->warnings_hr_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('hr_warning')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_warning')));
    }

    redirect(admin_url('hr/employee/warnings'));
  }

  public function shifts()
  {
    if (!has_permission('hr_employees', '', 'view')) {
              access_denied('hr_employees');
    }
    $data = [];
    $data['work_hours'] = [];
    $days = [0,1,2,3,4,5,6];
    $hours = [6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,0,1,2,3,4,5];  //8 inseamna 8-9

    foreach($days as $day){
        foreach(array_values($hours) as $hour){
            $gr = $day.'_'.$hour;
            //ulterior, ora trebuie sa fie transformata in indexul din categorii, de exemplu 8 are indexul 1
            $data['work_hours'][$gr] = [$hour,$day,0];
        }
    }
    //echo '<pre>';var_dump(json_encode($data['work_hours'])); exit;

    $data['shift_days'] = $this->shift_days_model->get();
    if(!empty($data['shift_days'])){
        foreach($data['shift_days'] as $sday){
            $start = $sday['start'];
            $start_expl = explode(':',$start);
            $start_h = $start_expl[0];
            $start_m = $start_expl[1];

            $end = $sday['end'];
            $end_expl = explode(':',$end);
            $end_h = $end_expl[0];
            $end_m = $end_expl[1];

            $day = $sday['day'] - 1;

            $hours = [];
            while($start_h <  $end_h){  //lipsa semnului <= confera -1 grad de libertate pentru ultimul interval
                $hours[] = $start_h;
                $start_h++;
            }
            if($end_m > 0){
                $hours[] = $end_h;//se elimina gradul de libertate
            }

            if(!empty($hours)){
                foreach($hours as $hour){
                    $gr = $day.'_'.$hour;
                    if(isset($data['work_hours'][$gr])){
                        $data['work_hours'][$gr][2]++;
                    }

                }
            }
        }
    }

    //index hours
    $data['indexed_hours'] = [
        //hour=>index
        '6'=>0,
        '7'=>1,
        '8'=>2,
        '9'=>3,
        '10'=>4,
        '11'=>5,
        '12'=>6,
        '13'=>7,
        '14'=>8,
        '15'=>9,
        '16'=>10,
        '17'=>11,
        '18'=>12,
        '19'=>13,
        '20'=>14,
        '21'=>15,
        '22'=>16,
        '23'=>17,
        '0'=>18,
        '1'=>19,
        '2'=>20,
        '3'=>21,
        '4'=>22,
        '5'=>23,

    ];
    if(!empty($data['work_hours'])){
    foreach($data['work_hours'] as $k=>$wh){
        if(isset($data['indexed_hours'][$data['work_hours'][$k][0]])){
            $data['work_hours'][$k][0] = $data['indexed_hours'][$data['work_hours'][$k][0]];
        }else{
            unset($data['work_hours'][$k]);
        }

    }}


    $data['work_hours_no_idx'] = [];
    if(!empty($data['work_hours'])){
    foreach($data['work_hours'] as $k=>$wh){
        $data['work_hours_no_idx'][] = $wh;
    }}
    //echo '<pre>';var_dump(json_encode($data['work_hours'])); exit;
    //echo '<pre>';var_dump($data['shift_days']); exit;
    $data['title'] = _l('hr_shifts');
    $this->load->view('employees/shifts', $data);
  }
  public function shift_days(){
    if (!has_permission('hr_employees', '', 'view')) {
              access_denied('hr_employees');
    }
    $data = [];
    $data['title'] = _l('hr_shift_days');
    $this->load->view('employees/shift_days', $data);
  }

  public function createShift($id = 0)
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = ['name' => $this->input->post('name')];
      $this->form_validation->set_rules('name', _l('name'), 'required');

      if ($this->form_validation->run() === true) {
        if (!$id) {
          $id = $this->shifts_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('hr_shift')));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->shifts_model->update($data, $id);
          if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('hr_shift')));
          }
        }

        $days = array_filter((array)$this->input->post('days'));
        $this->shift_days_model->deleteByShift($id);

        //echo '<pre>';var_dump($days); exit;
        foreach ($days as $day => $info) {
            //echo '<pre>';var_dump($info); exit;
          if (empty($info['start']) || empty($info['end'])){ continue; }
          $data             = $info;
          $data['day']      = $day;
          $data['shift_id'] = $id;

          $this->shift_days_model->add($data);
        }


        redirect(admin_url('hr/employee/createShift/' . $id));
      }
    }

    $shift = null;
    $days  = [];
    if ($id) {
      $shift = $this->shifts_model->get($id);

      if (!$shift) {
        show_404();
      }

    }

    $data = (array)$shift;
    if(!isset($data['id'])) $data['id'] = 0;
    if (set_value('id', $id ?? 0)){
      $data['title'] = _l('hr_edit_shift');
    }else{
      $data['title'] = _l('hr_new_shift');
    }

    $data['days']  = $this->shift_days_model->getByShift($id);

    //echo '<pre>';var_dump($data['days']); exit;
    $this->load->view('employees/createShift', $data);
  }

  public function removeShift($id)
  {
    $shift = $this->shifts_model->get($id);

    if (!$shift) {
      show_404();
    }

    if ($this->shifts_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('hr_shifts')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_shifts')));
    }

    redirect(admin_url('hr/employee/shifts'));
  }

  public function terminations()
  {
    if (!has_permission('hr_employees', '', 'view')) {
        access_denied('hr_employees');
    }
    $data = [];
    $data['title'] = _l('hr_terminations');
    $this->load->view('employees/terminations', $data);
  }

  public function createTermination($id = 0)
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->set_rules('type_id', _l('hr_type'), 'required');
      $this->form_validation->set_rules('user_id', _l('user_id'), 'required');
      $this->form_validation->set_rules('date', _l('hr_date_notice'), 'required');
      $this->form_validation->set_rules('date_finish', _l('hr_date_termination'), 'required');

      if ($this->form_validation->run() === true) {
        if (!$id) {
          $id = $this->terminations_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('hr_termination')));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->terminations_model->update($data, $id);
          if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('hr_termination')));
          }
        }

        redirect(admin_url('hr/employee/createTermination/' . $id));
      }
    }

    $termination = null;
    if ($id) {
      $termination = $this->terminations_model->get($id);

      if (!$termination) {
        show_404();
      }
    }

    $data = (array)$termination;
    if(!isset($data['id'])) $data['id'] = 0;

    $data['employees']   = $this->employees_model->get();
    $data['types']       = $this->termination_types_model->get();
    if (set_value('id', $data['id'] ?? 0)){
      $data['title'] = _l('hr_edit_termination');
    }else{
      $data['title'] = _l('hr_new_termination');
    }


    $this->load->view('employees/createTermination', $data);
  }

  public function removeTermination($id)
  {
    $termination = $this->terminations_model->get($id);

    if (!$termination) {
      show_404();
    }

    if ($this->terminations_model->delete($id) === true) {
      set_alert('success', _l('deleted', _l('hr_termination')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_termination')));
    }

    redirect(admin_url('hr/employee/terminations'));
  }

  public function createTerminationType($id = null)
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post()) {
      $data = $this->input->post();

      if (!$id) {
        if (!has_permission('hr_employees', '', 'create')) {
          access_denied('hr_employees');
        }

        $id = $this->termination_types_model->add($data);
        if ($id) {
          set_alert('success', _l('added_successfully', _l('hr_termination_type')));
          redirect(admin_url('hr/employee/createTerminationType/' . $id));
        }
      } else {
        if (!has_permission('hr_employees', '', 'edit')) {
          access_denied('hr_employees');
        }

        $success = $this->termination_types_model->update($data, $id);
        if ($success == true) {
          set_alert('success', _l('updated_successfully', _l('hr_termination_type')));
          redirect(admin_url('hr/employee/createTerminationType/' . $id));
        }
      }


    }

    $type          = null;

    if ($id) {
      $type = $this->termination_types_model->get($id);

      if (!$type) {
        if ($this->input->is_ajax_request()) {
          $data['status'] = 'error';
        } else {
          show_404();
        }
      }
    }

    $data['type'] = $type;

    if ($this->input->is_ajax_request()) {
      $data['status'] = 'success';
      echo json_encode($data);
      die();
    }

    $this->load->view('employee/createTerminationType', $data);
  }
}
