<?php defined('BASEPATH') or exit('No direct script access allowed');

class Holidays extends AdminController
{

  public function __construct()
  {
    parent::__construct();

    $this->load->model('employees_model');
    $this->load->model('holidays_model');

    $this->load->helper(['form', 'url']);
    $this->load->library('form_validation');

  }

  public function index()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }

    $data['title'] = _l('hr_holidays');

    $this->load->view('holidays/manage', $data);
  }

  public function create($id = '')
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();

      $this->form_validation->set_rules('start', _l('hr_start'), 'required');
      $this->form_validation->set_rules('end', _l('hr_end'), 'required');

      $this->form_validation->set_rules('user_id', _l('hr_employees'), 'required|numeric');

      if ($this->form_validation->run() === true) {
        if (!$id) {
          $id = $this->holidays_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('employee')));
          }
        } else {
          $success = $this->holidays_model->update($data, $id);

          if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('employee')));
          }
        }

        redirect(admin_url('hr/holidays/create/' . $id));
      }
    }

    $holiday = null;

    if ($id) {
      $holiday = $this->holidays_model->get($id);

      if (!$holiday) {
        show_404();
      }
    }

    $data = (array)$holiday;
    
    if (!isset($data['id'])) $data['id'] = 0;
    
    
    if (set_value('id', $data['id'] ?? 0)){
        $data['title'] = _l('hr_edit_holiday');
    }else{
        $data['title'] = _l('hr_new_holiday');
    }
    

    $data['employees'] = $this->employees_model->get(0);

    $this->load->view('holidays/create', $data);
  }

  public function remove($id = 0)
  {
    $holiday = $this->holidays_model->get((int)$id);

    if (!$holiday) {
      show_404();
    }

    $success = $this->holidays_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('hr_holidays')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_holidays')));
    }

    redirect(admin_url('hr/holidays/'));
  }
}
