<?php defined('BASEPATH') or exit('No direct script access allowed');

class Travels extends AdminController
{

  public function __construct()
  {
    parent::__construct();

    $this->load->model('employees_model');
    $this->load->model('travels_model');
    $this->load->model('travel_types_model');
    $this->load->model('travel_modes_model');

    $this->load->helper(['form', 'url']);
    $this->load->library('form_validation');

  }

  public function index()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }

    $data['title'] = _l('hr_travels');

    $this->load->view('travels/manage', $data);
  }

  public function create($id = '')
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->set_rules('user_id', _l('hr_department_head'), 'required');
      $this->form_validation->set_rules('description', _l('description'), 'required');
      $this->form_validation->set_rules('date_start', _l('hr_start'), 'required');
      $this->form_validation->set_rules('date_end', _l('hr_end'), 'required');
      if ($this->form_validation->run() === true) {
        if (!$id) {
          if (!has_permission('hr_employees', '', 'create')) {
            access_denied('hr_employees');
          }

          $id = $this->travels_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('employee')));
          }
        } else {
          if (!has_permission('hr_employees', '', 'edit')) {
            access_denied('hr_employees');
          }

          $success = $this->travels_model->update($data, $id);

          if ($success == true) {

            set_alert('success', _l('updated_successfully', _l('employee')));
          }
        }

        redirect(admin_url('hr/travels/create/' . $id));
      }
    }

    $travel = null;

    if ($id) {
      $travel = $this->travels_model->get($id);

      if (!$travel) {
        show_404();
      }
    }

    $data = (array)$travel;
    //if (isset($data['id'])) $data['id'] = 0;

    $data['employees'] = $this->employees_model->get(0);
    $data['types']     = $this->travel_types_model->getAll();
    $data['modes']     = $this->travel_modes_model->getAll();

    if (set_value('id', $data['id'] ?? 0)){
       $data['title'] = _l('hr_edit_travel');
    }else{
      $data['title'] = _l('hr_new_travel');
    }

    $this->load->view('travels/create', $data);
  }

  public function remove($id = 0)
  {
    $travel = $this->travels_model->get((int)$id);

    if (!$travel) {
      show_404();
    }

    $success = $this->travels_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('hr_travels')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_travels')));
    }

    redirect(admin_url('hr/travels/'));
  }

  public function modes()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }
    $data['title'] = _l('modes');
    $this->load->view('travels/manageModes', $data);
  }

  public function createMode()
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $id = (int)$this->input->post('id', true);

    if ($this->input->post()) {
      $data = $this->input->post();
      $this->form_validation->set_rules('name', _l('name'), 'required');

      if ($this->form_validation->run() === true) {
        if (!$id) {
          $id = $this->travel_modes_model->add($data);
        } else {
          $this->travel_modes_model->update($data, $id);
        }
      }
    }

    $mode = $this->travel_modes_model->get($id);

    if (!$mode) {
      set_alert('danger', _l('updated_unsuccessfully', _l('employee')));
    } else {
      set_alert('success', _l('updated_successfully', _l('employee')));
    }

    redirect(admin_url('hr/travels/modes/'));
  }

  public function getMode()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $mode = $this->travel_modes_model->get($this->input->post('id', true));

    if (!$mode) {
      ajax_error(_l('error'));
    }

    _ok_response(['status' => 1, 'mode' => $mode]);
  }

  public function removeMode($id = 0)
  {
    $mode = $this->travel_modes_model->get((int)$id);

    if (!$mode) {
      show_404();
    }

    $success = $this->travel_modes_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('categories')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('categories')));
    }

    redirect(admin_url('hr/travels/modes'));
  }

  public function types()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }
    $data['title'] = _l('types');
    $this->load->view('travels/manageTypes', $data);
  }

  public function createType()
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $id = (int)$this->input->post('id', true);

    if ($this->input->post()) {
      $data = $this->input->post();

      if (!$id) {
        $id = $this->travel_types_model->add($data);
      } else {
        $this->travel_types_model->update($data, $id);
      }
    }

    $type = $this->travel_types_model->get($id);

    if (!$type) {
      set_alert('danger', _l('updated_successfully', _l('employee')));
    } else {
      set_alert('success', _l('updated_successfully', _l('employee')));
    }

    redirect(admin_url('hr/travels/types/'));
  }

  public function getType()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $type = $this->travel_types_model->get($this->input->post('id', true));

    if (!$type) {
      ajax_error(_l('error'));
    }

    _ok_response(['status' => 1, 'type' => $type]);
  }

  public function removeType($id = 0)
  {
    $type = $this->travel_types_model->get((int)$id);

    if (!$type) {
      show_404();
    }

    $success = $this->travel_types_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('categories')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('categories')));
    }

    redirect(admin_url('hr/travels/types'));
  }
}
