<?php defined('BASEPATH') or exit('No direct script access allowed');

class Workshops extends AdminController
{

  public function __construct()
  {
    parent::__construct();

    $this->load->model('employees_model');
    $this->load->model('workshops_model');
    $this->load->model('workshop_types_model');
    $this->load->model('workshop_modes_model');

    $this->load->model('workshop_users_model');

    $this->load->helper(['form', 'url']);
    $this->load->library('form_validation');

  }

  public function index()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }

    $data['title'] = _l('hr_workshops');

    $this->load->view('workshops/manage', $data);
  }

  public function create($id = null)
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
       $this->form_validation->set_rules('description', _l('description'), 'required');
       $this->form_validation->set_rules('date_start', _l('hr_start'), 'required');
      $this->form_validation->set_rules('date_end', _l('hr_end'), 'required');
 /*



      if(isset($data['mode']) && $data['mode'] == 'internal'){
        $this->form_validation->set_rules('trainer_id', _l('hr_trainer_name'), 'required');
      } else {
        $this->form_validation->set_rules('trainer_name', _l('hr_trainer_name'), 'required');
      }

      $this->form_validation->set_rules('type_id', _l('type'), 'required');
      $this->form_validation->set_rules('user_id[]', _l('hr_employees'), 'required');
      $this->form_validation->set_rules('mode', _l('hr_workshop_option'), 'required');
*/
      if ($this->form_validation->run() === true) {
        if (!$id) {
          $id = $this->workshops_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('employee')));
          }

        } else {
          $success = $this->workshops_model->update($data, $id);

          if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('employee')));
          }
        }
        redirect(admin_url('hr/workshops'));
        //redirect(admin_url('hr/workshops/create/' . $id));
      }else{

      }
    }

    $whorkshop = null;

    if ($id) {
      $whorkshop = $this->workshops_model->get($id);

      if (!$whorkshop) {
        show_404();
      }
    }

    $data = (array)$whorkshop;

    //if (!isset($data['id'])) $data['id'] = 0;

    $data['employees'] = $this->employees_model->get(0);
    $data['trainers'] = $this->employees_model->get(0);
    $data['types']     = $this->workshop_types_model->getAll();
    if(isset($data['id'])){
    $data['user_id']     = $this->workshop_users_model->getAllByWorkshopId($data['id'], true);
    }else{
        $data['user_id'] = [];
    }
    if (set_value('id', $data['id'] ?? 0)){
       $data['title'] = _l('hr_edit_workshop');
    }else{
        $data['title'] = _l('hr_new_workshop');
    }


    $this->load->view('workshops/create', $data);
  }

  public function remove($id = 0)
  {
    $workshop = $this->workshops_model->get((int)$id);

    if (!$workshop) {
      show_404();
    }

    $success = $this->workshops_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('hr_workshops')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_workshops')));
    }

    redirect(admin_url('hr/workshops/'));
  }

  public function types()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }
    $data['title'] = _l('types');
    $this->load->view('workshops/manageTypes', $data);
  }

  public function createType()
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $id = (int)$this->input->post('id', true);

    if ($this->input->post()) {
      $data = $this->input->post();

      if (!$id) {
        $id = $this->workshop_types_model->add($data);
      } else {
        $this->workshop_types_model->update($data, $id);
      }
    }

    $type = $this->workshop_types_model->get($id);

    if (!$type) {
      set_alert('danger', _l('updated_successfully', _l('employee')));
    } else {
      set_alert('success', _l('updated_successfully', _l('employee')));
    }

    redirect(admin_url('hr/workshops/types/'));
  }

  public function getType()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $type = $this->workshop_types_model->get($this->input->post('id', true));

    if (!$type) {
      ajax_error(_l('error'));
    }

    _ok_response(['status' => 1, 'type' => $type]);
  }

  public function removeType($id = 0)
  {
    $type = $this->workshop_types_model->get((int)$id);

    if (!$type) {
      show_404();
    }

    $success = $this->workshop_types_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('types')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('types')));
    }

    redirect(admin_url('hr/workshops/types'));
  }



  public function modes()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      if (!have_assigned_customers() && !has_permission('customers', '', 'create')) {
        access_denied('customers');
      }
    }
    $data['title'] = _l('modes');
    $this->load->view('workshops/manageModes', $data);
  }

  public function createModes()
  {
    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $id = (int)$this->input->post('id', true);

    if ($this->input->post()) {
      $data = $this->input->post();

      if (!$id) {
        $id = $this->workshop_modes_model->add($data);
      } else {
        $this->workshop_modes_model->update($data, $id);
      }
    }

    $type = $this->workshop_modes_model->get($id);

    if (!$type) {
      set_alert('danger', _l('updated_successfully', _l('employee')));
    } else {
      set_alert('success', _l('updated_successfully', _l('employee')));
    }

    redirect(admin_url('hr/workshops/modes/'));
  }

  public function getMode()
  {

    if (!has_permission('hr_employees', '', 'view')) {
      access_denied('hr_employees');
    }

    $type = $this->workshop_modes_model->get($this->input->post('id', true));

    if (!$type) {
      ajax_error(_l('error'));
    }

    _ok_response(['status' => 1, 'type' => $type]);
  }

  public function removeMode($id = 0)
  {
    $type = $this->workshop_modes_model->get((int)$id);

    if (!$type) {
      show_404();
    }

    $success = $this->workshop_modes_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('modes')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('modes')));
    }

    redirect(admin_url('hr/workshops/modes'));
  }
}
