<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @param  int $id
 * @param  string $file
 * @param  string $path
 * @param  string $table
 * @param  string $param
 * @param  string $allowed
 *
 * @return bool
 */
function add_file($id, $file, $path, $table, $param, $file_name = '', $allowed = 'gif|jpg|png|pdf|csv', $max_size = 2048, $overwrite = true){
  $CI           = & get_instance();

  _maybe_create_upload_path(HR_UPLOAD_REAL);
  _maybe_create_upload_path($path);

  if (isset($_FILES[$file]['name']) && $_FILES[$file]['name'] != '') {
    if($file_name){
      $config['file_name']          = $file_name;
    }

    $config['upload_path']          = $path;
    $config['allowed_types']        = $allowed;
    $config['max_size']             = $max_size;
    $config['overwrite']            = $overwrite;
    $CI->load->library('upload', $config);

    if(! $CI->upload->do_upload($file)){
      return $CI->upload->display_errors();
    } else {
      $data = $CI->upload->data();
      $CI->db->query("UPDATE ".db_prefix().$table." SET {$param}='{$data['file_name']}' WHERE id={$id}");

      return true;
    }
  }

  return false;
}


/**
 * @param string|array $response
 */
function _ok_response($response = null)
{
  if ($response === null) {
    die('OK');
  }

  if (!is_array($response)) {
    $response = ['status' => 1, 'message' => $response];
  }

  if (!headers_sent()) {
    header('HTTP/1.0 200 OK', true, 200);
  }

  header('Content-Type: application/json; charset=utf-8');
  die(json_encode($response));
}

/**
 * Ritorna un messaggio di errore utilizzando un HTTP_STATUS corretto
 *
 * @param string $message
 * @param string $http_status
 */
function ajax_error($message = 'Errore', $http_status = '404')
{
  if (!headers_sent()) {
    switch ($http_status) {
      case '400':
        // La richiesta non può essere soddisfatta a causa di errori di sintassi.
        header('HTTP/1.0 400 Bad request', true, 400);
        break;
      case '401':
        // L'autenticazione è possibile ma è fallita o non può essere fornita.
        header('HTTP/1.0 401 Unauthorized', true, 401);
        break;
      case '403':
        // L'utente autenticato non è abilitato a fare questa richiesta.
        header('HTTP/1.0 403 Forbidden', true, 403);
        break;
      case '404':
        // La risorsa richiesta non è stata trovata
        header('HTTP/1.0 404 Not found', true, 404);
        break;
      case '406':
        // La risorsa richiesta è solo in grado di generare contenuti non accettabili secondo la header Accept inviato nella richiesta
        header('HTTP/1.0 406 Not acceptable', true, 406);
        break;
      case '500':
        // Errore del server generico
        header('HTTP/1.0 500 Internal Server Error', true, 500);
        break;
      case '503':
        // Servizio non disponibile
        header('HTTP/1.0 503 Service Unavailable', true, 503);
        break;
      default:
        header('HTTP/1.0 400 Bad request', true, 400);
        break;
    }
  }
  header('Content-Type: text/plain; charset=utf-8');

  die($message);
}


/**
 * Get all countries stored in database
 * @return array
 */
function get_all_cities_with_zones()
{
  $CI =& get_instance();
  $CI->db->select(db_prefix() . 'cities.*, '.db_prefix().'zones.name as zone_name');
  $CI->db->join(db_prefix() . 'zones', '' . db_prefix() . 'cities.zone_id = ' . db_prefix() . 'zones.id');
  return hooks()->apply_filters('all_cities', $CI->db->order_by('name', 'asc')->get(db_prefix().'cities')->result_array());
}