<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
Module Name: Hr
Description: Hr Module
Version: 2.0.0
*/

define('HR_MODULE_NAME', 'hr');
define('HR_UPLOAD_REAL', FCPATH . 'uploads/hr/');
define('HR_UPLOAD_BASE', APP_BASE_URL . 'uploads/hr/');

define('HR_UPLOAD_AWARD_REAL', FCPATH . 'uploads/hr/awards/');
define('HR_UPLOAD_AWARD_BASE', APP_BASE_URL . 'uploads/hr/awards/');

define('HR_UPLOAD_DOCUMENT_REAL', FCPATH . 'uploads/hr/documents/');
define('HR_UPLOAD_DOCUMENT_BASE', APP_BASE_URL . 'uploads/hr/documents/');


$CI = &get_instance();

hooks()->add_action('admin_init', 'hr_register_permissions');
hooks()->add_action('admin_init', 'hr_register_menu_items');
//hooks()->add_action('after_cron_run', 'hr_send_email_templates');

//register_merge_fields('hr/merge_fields/hr_merge_fields');
//hooks()->add_filter('other_merge_fields_available_for', 'hr_register_other_merge_fields');
//hooks()->add_filter('available_merge_fields', 'hr_allow_staff_merge_fields_for_appointment_templates');

//hooks()->add_filter('get_dashboard_widgets', 'hr_register_dashboard_widgets');
//get_instance()->load->config('form_validation');


/**
 * Get todays appointments to render in dashboard widget
 *
 * @param [array] $widgets
 * @return array
 */
//function hr_register_dashboard_widgets($widgets)
//{
//    $widgets[] = [
//        'container' => 'left-8',
//        'path' => 'appointly/widgets/today_appointments',
//    ];
//
//    return $widgets;
//}



/**
 * Hook for assigning staff permissions for hr module
 *
 * @return void
 */
function hr_register_permissions()
{
    $capabilities = [];

    $capabilities['capabilities'] = [
        'view'   => _l('permission_view') . '(' . _l('permission_global') . ')',
        'view_own'   => _l('permission_view_own'),
        'create' => _l('permission_create'),
        'edit'   => _l('permission_edit'),
        'delete' => _l('permission_delete'),
    ];

    register_staff_capabilities('hr', $capabilities, _l('hr'), _l('hr_permissions'));
}


/**
 * Register new menu item in sidebar menu
 */
function hr_register_menu_items()
{
    $CI = &get_instance();
    $slug_menu = 'hr_employee';
    if (staff_can('view', 'hr') || staff_can('view_own', 'hr')) {
        /*$CI->app_menu->add_sidebar_children_item('dashboard', ['slug'=>'dashboard_hr',
            'name'     => _l('menu_hr__hr_dashboard'),
            'href'     => admin_url('hr/dashboard'),
        //'icon'     => 'fal fa-chart-pie',
            'position' => 9,
        ]);*/
        $CI->app_menu->add_sidebar_menu_item($slug_menu, [
            'name'     => _l('menu_hr'),
            'href'     => admin_url('hr/dashboard'),
            'icon'     => 'fal fa-users-class',
            'position' => 170,
            'collapse' => true,
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
            'slug'     => 'hr_sidemenu hr-user-dashboard',
            'name'     => _l('menu_hr__employees'),
            'href'     => admin_url('hr/employee'),
            'position' => 1,
            //'icon'     => 'fal fa-users',
        ]);
        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-user-dashboard',
          'name'     => _l('menu_hr__departments'),
          'href'     => admin_url('hr/company'),
          'position' => 1,
          //'icon'     => 'fal fa-users',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-user-locations',
          'name'     => _l('menu_hr__locations'),
          'href'     => admin_url('hr/company/locations'),
          'position' => 22,
          //'icon'     => 'fal fa-map-marked',
        ]);


        $CI->app_menu->add_sidebar_children_item($slug_menu, [
            'slug'     => 'hr_sidemenu hr-expire_documents',
            'name'     => _l('menu_hr__documents'),
            'href'     => admin_url('hr/documents'),
            'position' => 2,
            //'icon'     => 'fal fa-files',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-awards',
          'name'     => _l('menu_hr__awards'),
          'href'     => admin_url('hr/awards'),
          'position' => 2,
          //'icon'     => 'fal fa-trophy',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-transfers',
          'name'     => _l('menu_hr__transfers'),
          'href'     => admin_url('hr/employee/transfers'),
          'position' => 2,
          //'icon'     => 'fal fa-truck',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-resignations',
          'name'     => _l('menu_hr__resignations'),
          'href'     => admin_url('hr/employee/resignations'),
          'position' => 2,
          //'icon'     => 'fal fa-times',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-trips',
          'name'     => _l('menu_hr__travels'),
          'href'     => admin_url('hr/travels'),
          'position' => 2,
          //'icon'     => 'fal fa-train',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-promotions',
          'name'     => _l('menu_hr__promotions'),
          'href'     => admin_url('hr/employee/promotions'),
          'position' => 2,
          //'icon'     => 'fal fa-trophy',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-complaints',
          'name'     => _l('menu_hr__complaints'),
          'href'     => admin_url('hr/employee/complaints'),
          'position' => 2,
          //'icon'     => 'fal fa-exclamation',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-warnings',
          'name'     => _l('menu_hr__warnings'),
          'href'     => admin_url('hr/employee/warnings'),
          'position' => 2,
          //'icon'     => 'fal fa-exclamation-triangle',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-contractual_terminations',
          'name'     => _l('menu_hr__contractual_terminations'),
          'href'     => admin_url('hr/employee/terminations'),
          'position' => 2,
          //'icon'     => 'fal fa-times',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-shifts',
          'name'     => _l('menu_hr__shifts'),
          'href'     => admin_url('hr/employee/shifts'),
          'position' => 2,
          //'icon'     => 'fal fa-anchor',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-holidays',
          'name'     => _l('menu_hr__holidays'),
          'href'     => admin_url('hr/holidays'),
          'position' => 2,
          //'icon'     => 'fal fa-calendar',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-checkins',
          'name'     => _l('menu_hr__checkins'),
          'href'     => admin_url('hr/checkins'),
          'position' => 2,
          //'icon'     => 'fal fa-check',
        ]);

        $CI->app_menu->add_sidebar_children_item($slug_menu, [
          'slug'     => 'hr_sidemenu hr-workshops',
          'name'     => _l('menu_hr__workshops'),
          'href'     => admin_url('hr/workshops'),
          'position' => 2,
          //'icon'     => 'fal fa-check',
        ]);


        $CI->app_menu->add_setup_children_item('staff', [
            'slug' => 'staff_designations_setting',
            'name' => _l('setup_menu_staff_designations'),
            'href' => admin_url('hr/company/designations'),
            'position' => 7,
        ]);

    }
}


/**
 * Register activation hook
 */
register_activation_hook(HR_MODULE_NAME, 'hr_activation_hook');

register_deactivation_hook(HR_MODULE_NAME, 'hr_deactivation_hook');


/**
 * The activation function
 */
function hr_activation_hook()
{
    require(__DIR__ . '/install.php');
}

/**
 * The activation function
 */
function hr_deactivation_hook()
{
  require(__DIR__ . '/desinstall.php');
}


/**
 * Register module language files
 */
register_language_files(HR_MODULE_NAME, ['hr']);


/**
 * Loads the module function helper
 */
$CI->load->helper(HR_MODULE_NAME . '/hr');


/**
 * Check if can have permissions then apply new tab in settings
 */
if (staff_can('view', 'settings')) {
    hooks()->add_action('admin_init', 'hr_add_settings_tab');
}

/**
 * @return void
 */
function hr_add_settings_tab()
{
    $CI = &get_instance();
  /*  $CI->app_tabs->add_settings_tab('hr-settings', [
        'name'     => _l('app_tab_hr_settings'),
        'view'     => 'hr/settings',
        'position' => 36,
    ]);*/
}



function controller_staff_member_after_perm()
{
    $CI = &get_instance();

    //$CI->load->model('shift_days_model');

}

hooks()->add_filter('staff_after_tabs_button', 'staff_after_tabs_button', 10,0);
function staff_after_tabs_button(){
  return '<li role="presentation">
     <a href="#staff_hr_data" aria-controls="staff_hr_data" role="tab" data-toggle="tab">
      '. _l('staff_add_edit_hr_data').'
     </a>
  </li>';

}

hooks()->add_filter('staff_after_tabs_content', 'staff_after_tabs_content', 10,2);
function staff_after_tabs_content($data = [],$id = null){
  $CI = &get_instance();
  $CI->load->model('hr/employees_model');
  $CI->load->model('hr/locations_model');
  //$CI->load->model('hr/departments_hr_model');
  $CI->load->model('departments_model');
  $CI->load->model('hr/shifts_model');
  $CI->load->model('hr/designations_hr_model');

  if($id){
    $employee = $CI->employees_model->get($id);
    $data['member'] = (object) array_merge((array) $data['member'], (array) $employee);
    //$data['departments'] = $CI->departments_hr_model->getByLocation((int)$employee->location_id);
  }else{
    //$data['departments'] = $CI->departments_hr_model->getByLocation();
  }

  $departments = $CI->departments_model->get();

  $data['employees']   = $CI->employees_model->getWithout($id);
  $data['locations']   = $CI->locations_model->get(0);
  $data['shifts']      = $CI->shifts_model->get(0);



  return $CI->load->view('hr/employees/staff_tab_form',$data,true);
}

hooks()->add_filter('staff_member_extra', 'staff_merge_hr_data', 10,1);
function staff_merge_hr_data($member){
  return $member;
}

hooks()->add_filter('staff_before_update_data', 'staff_before_update_data_hr', 10,1);
function staff_before_update_data_hr($data){
  if(isset($data['hr'])){ unset($data['hr']); }
  return $data;
}

hooks()->add_filter('staff_after_update_data', 'staff_after_update_data_hr', 10,2);
function staff_after_update_data_hr($data,$id){
  $CI = &get_instance();
  $CI->load->model('hr/employees_model');
  $CI->employees_model->update($data['hr'], $id);
}
