<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_110 extends App_module_migration
{
     public function up()
     {
          $CI = &get_instance();
          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_employees (
                      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                      `firstname` varchar(255) NOT NULL,
                      `lastname` varchar(255) NOT NULL,
                      `employee_id` varchar(255) NOT NULL,
                      `phonenumber` varchar(255) NOT NULL,
                      `email` varchar(255) NOT NULL,
                      `gender` enum('male', 'female') default 'male',
                      `birthdate` datetime NOT NULL,
                      `address` varchar(255) NOT NULL,
                      `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                      `parent_id` int(11) NOT NULL DEFAULT 0,
                      `designation_id` int(11) NOT NULL DEFAULT 0,
                      `shift_id` int(11) NOT NULL DEFAULT 0,
                      `location_id` int(11) NOT NULL DEFAULT 0,
                      `department_id` int(11) NOT NULL DEFAULT 0,
                      `zip_code` varchar(15) DEFAULT NULL ,
                      `country_id` int(11) NOT NULL DEFAULT 0,
                      `city_id` int(11) NOT NULL DEFAULT 0,
                      `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
                      `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
                      PRIMARY KEY (`id`)
                      ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_travel_modes (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `name` varchar(255) NOT NULL,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_travel_types (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `name` varchar(255) NOT NULL,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_travels (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `description` text NULL DEFAULT NULL,
                     `scope` varchar(255) NOT NULL,
                     `place` varchar(255) NOT NULL,
                     `budget` decimal(10,4) NULL DEFAULT NULL,
                     `actual_budget` decimal(10,4) NULL DEFAULT NULL,
                     `date_start` datetime NOT NULL,
                     `date_end` datetime NOT NULL,
                     `user_id` int(11) NOT NULL,
                     `type_id` int(11) NOT NULL,
                     `mode_id` int(11) NOT NULL,
                     `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_transfers (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `description` text NULL DEFAULT NULL,
                     `date` date NOT NULL,
                     `user_id` int(11) NOT NULL,
                     `department_id` int(11) NOT NULL,
                     `location_id` int(11) NOT NULL,
                     `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_resignations (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `description` text NULL DEFAULT NULL,
                     `date` datetime NOT NULL,
                     `date_resignation` datetime NOT NULL,
                     `user_id` int(11) NOT NULL,
                     `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_complaints (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `title` varchar(255) NOT NULL,
                     `description` text NULL DEFAULT NULL,
                     `date` datetime NOT NULL,
                     `from_user_id` int(11) NOT NULL,
                     `user_id` int(11) NOT NULL,
                     `type_id` int(11) NOT NULL,
                     `img` varchar(255) NOT NULL,
                     `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_warnings (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `title` varchar(255) NOT NULL,
                     `description` text NULL DEFAULT NULL,
                     `date` datetime NOT NULL,
                     `from_user_id` int(11) NOT NULL,
                     `user_id` int(11) NOT NULL,
                     `type_id` int(11) NOT NULL,
                     `img` varchar(255) NOT NULL,
                     `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_end_contracts (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `description` text NULL DEFAULT NULL,
                     `date` datetime NOT NULL,
                     `date_finish` datetime NOT NULL,
                     `user_id` int(11) NOT NULL,
                     `type_id` int(11) NOT NULL,
                     `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_end_contract_types (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `type` varchar(255) NOT NULL,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_promotions (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `title` varchar(255) NOT NULL,
                     `description` text NULL DEFAULT NULL,
                     `date` datetime NOT NULL,
                     `user_id` int(11) NOT NULL,
                     `designation_id` int(11) NOT NULL,
                     `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_shifts (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `name` varchar(255) NOT NULL,
                     `start` varchar(5) NULL DEFAULT NULL,
                     `end` varchar(5) NULL DEFAULT NULL,
                     `day` tinyint(1) UNSIGNED NOT NULL,
                     `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_shift_days (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `start` varchar(5) NULL DEFAULT NULL,
                     `end` varchar(5) NULL DEFAULT NULL,
                     `day` tinyint(1) UNSIGNED NOT NULL,
                     `shift_id` int(11) UNSIGNED NOT NULL,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );


          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_holidays (
                      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                      `start` date NOT NULL,
                      `end` date NOT NULL,
                      `description` text NULL DEFAULT NULL,
                      `user_id` int(11) UNSIGNED NOT NULL,
                      `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                      PRIMARY KEY (`id`)
                      ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_company_locations (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `name` varchar(255) NOT NULL,
                     `email` varchar(255) NULL DEFAULT NULL,
                     `phone` varchar(255) NULL DEFAULT NULL,
                     `fax` varchar(255) NULL DEFAULT NULL,
                     `address` varchar(255) NULL DEFAULT NULL,
                     `zip` varchar(255) NULL DEFAULT NULL,
                     `city_id` int(11) NOT NULL,
                     `zone_id` int(11) NOT NULL,
                     `country_id` int(11) NOT NULL,
                     `user_id` int(11) NOT NULL,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_awards (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `name` varchar(255) NOT NULL,
                     `gift` varchar(255) DEFAULT NULL,
                     `cash` decimal(10,4) DEFAULT NULL,
                     `description` text DEFAULT NULL,
                     `information` text DEFAULT NULL,
                     `img` varchar(255) DEFAULT NULL,
                     `award_type_id` int(11) NOT NULL,
                     `date` date NOT NULL,
                     `month` varchar(20) DEFAULT NULL,
                     `user_id` int(11) NOT NULL,
                     `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_award_types (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `name` varchar(255) NOT NULL,
                     `description` varchar(255) NOT NULL,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_locations (
                      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                      `name` varchar(255) NOT NULL,
                      `user_id` varchar(255) NOT NULL,
                      `phonenumber` varchar(255) NOT NULL,
                      `email` varchar(255) NOT NULL,
                      `gender` enum('male', 'female') default 'male',
                      `birthdate` datetime NOT NULL,
                      `address` varchar(255) NOT NULL,
                      `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                      `employee_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
                      `zip_code` varchar(15) DEFAULT NULL ,
                      `country_id` int(11) NOT NULL DEFAULT 0,
                      `city_id` int(11) NOT NULL DEFAULT 0,
                      `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
                      `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
                      PRIMARY KEY (`id`)
                      ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;"
          );

         /* $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_departments (
                      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                      `name` varchar(255) NOT NULL,
                      `user_id` varchar(255) NOT NULL,
                      `location_id` varchar(255) NOT NULL,
                      `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                      `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
                      `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
                      PRIMARY KEY (`id`)
                      ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;"
          );*/

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_documents (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `name` varchar(255) NOT NULL,
                     `number` varchar(255) NOT NULL,
                     `filename` varchar(255) NOT NULL,
                     `date_expire` date NOT NULL,
                     `user_id` int(11) DEFAULT NULL,
                     `type_id` int(11) DEFAULT NULL,
                     `department_id` int(11) DEFAULT NULL,
                     `category_id` int(11) DEFAULT NULL,
                     `addedfrom` int(11) UNSIGNED NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_document_categories (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `name` varchar(255) NOT NULL,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_document_types (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `name` varchar(255) NOT NULL,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_workshops (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `description` text NULL DEFAULT NULL,
                     `mode` enum('internal', 'external') DEFAULT 'internal',
                     `cost` decimal(10,4) NULL DEFAULT NULL,
                     `date_start` datetime NOT NULL,
                     `date_end` datetime NOT NULL,
                     `trainer_id` int(11) NOT NULL,
                     `type_id` int(11) NOT NULL,
                     `trainer_name` varchar(255) NOT NULL,
                     `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_workshop_employees (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `user_id` int(11) NOT NULL,
                     `workshop_id` int(11) NOT NULL,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_workshop_types (
                     `id` int(11) NOT NULL AUTO_INCREMENT,
                     `name` varchar(255) NOT NULL,
                     PRIMARY KEY (`id`)
                     ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
          );

          $CI->db->query(
            "CREATE TABLE IF NOT EXISTS " . db_prefix() . "hr_checkins (
                      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
                      `start` datetime NOT NULL,
                      `end` datetime NOT NULL,
                      `user_id` int(11) UNSIGNED NOT NULL,
                      `addedfrom` int(11) UNSIGNED NOT NULL DEFAULT 0,
                      PRIMARY KEY (`id`)
                      ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;"
          );


          /* @since 2.0.0 */
          $CI->db->query("ALTER TABLE `" . db_prefix() . "staff` ADD `gender` ENUM('male','female') NULL DEFAULT NULL AFTER `is_super_admin`;");
          $CI->db->query("ALTER TABLE `" . db_prefix() . "hr_complaints`ADD`id_status` INT(11) NULL AFTER `addedfrom`;");
          $CI->db->query("CREATE TABLE IF NOT EXISTS `" . db_prefix() . "hr_complaints_status`(`id` INT(11) NOT NULL AUTO_INCREMENT , `name` CHAR(255) NOT NULL , PRIMARY KEY (`id`)) ENGINE = InnoDB;");
          $CI->db->query("ALTER TABLE `" . db_prefix() . "hr_employees`ADD`id_staff` INT(11) NULL AFTER `id`;");

     }
}
