<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Company_departments_model
 */
class Company_departments_model extends App_Model
{

    public $table_name = 'hr_company_departments';

    /**
     * Create new department
     *
     * @param array $data
     *
     * @return int
     */
    public function add($data)
    {
        $this->db->insert(db_prefix() . $this->table_name, $data);

        $employee_id = $this->db->insert_id();
        $log         = 'ID: ' . $employee_id;

        $isStaff = null;
        if (is_staff_logged_in()) {
            $log     .= ', From Staff: ' . get_staff_user_id();
            $isStaff = get_staff_user_id();
        }

        log_activity('New Department Created [' . $log . ']', $isStaff);

        return $employee_id;
    }

    /**
     * Update department
     *
     * @param array $data
     * @param integer ID
     *
     * @return boolean
     */
    public function update($data, $id)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . $this->table_name, $data);


        if ($this->db->affected_rows() > 0) {
            log_activity('Department Info Updated [ID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Get department
     *
     * @param int|null $id
     *
     * @return array
     */
    public function get($id)
    {
        $id = is_numeric($id) ? (int)$id : 0;

        if ($id) {
            $this->db->where('id', $id);

            return $this->db->get(db_prefix() . $this->table_name)->row();
        }

        $this->db->order_by('name', 'asc');

        return $this->db->get(db_prefix() . $this->table_name)->result_array();
    }

    /**
     * Delete employee
     *
     * @param int $id
     *
     * @return bool
     */
    public function delete($id)
    {
        $this->db->where('id', (int)$id);
        $this->db->delete(db_prefix() . $this->table_name);

        return $this->db->affected_rows() > 0;
    }
}
