<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Complaints_hr_model
 */
class Complaints_hr_model extends App_Model
{

  public $table_name = 'hr_complaints';

  /**
   * Create new employee
   *
   * @param array $data
   *
   * @return int
   */
  public function add($data)
  {
    if (is_staff_logged_in()) {
      $data['addedfrom'] = get_staff_user_id();
    }

    $data['date']  = date('Y-m-d', strtotime($data['date']));

    $this->db->insert(db_prefix() . $this->table_name, $data);

    $id  = $this->db->insert_id();
    $log = 'ID: ' . $id;

    $isStaff = null;
    if (!is_client_logged_in() && is_staff_logged_in()) {
      $log     .= ', From Staff: ' . get_staff_user_id();
      $isStaff = get_staff_user_id();
    }

    log_activity('New Complain Created [' . $log . ']', $isStaff);

    return $id;
  }

  /**
   * Update employye informations
   *
   * @param array $_POST data
   * @param integer ID
   *
   * @return boolean
   */
  public function update($data, $id)
  {
    $this->db->where('id', $id);

    $data['date']  = date('Y-m-d', strtotime($data['date']));

    $this->db->update(db_prefix() . $this->table_name, $data);

    if ($this->db->affected_rows() > 0) {
      log_activity('Complain Info Updated [ID: ' . $id . ']');

      return true;
    }

    return false;
  }

  /**
   * Get employee
   *
   * @param int|null $id
   *
   * @return array
   */
  public function get($id){
    $id = is_numeric($id) ? (int)$id : null;

    $this->db->select('*,
        (CASE WHEN ISNULL('.db_prefix().'staff.staffid) THEN '.db_prefix().'hr_employees.firstname ELSE '.db_prefix().'staff.firstname END
        ) as firstname,
        (CASE WHEN ISNULL('.db_prefix().'staff.staffid) THEN '.db_prefix().'hr_employees.lastname ELSE '.db_prefix().'staff.lastname END
        ) as lastname,

        CONCAT(COALESCE(staff_from.firstname)," ", COALESCE(staff_from.lastname))
           as from_user,
        (CASE WHEN ISNULL('.db_prefix().'staff.staffid) THEN CONCAT(COALESCE('.db_prefix().'hr_employees.firstname)," ", COALESCE('.db_prefix().'hr_employees.lastname)) ELSE CONCAT(COALESCE('.db_prefix().'staff.firstname)," ", COALESCE('.db_prefix().'staff.lastname)) END
         ) as fullname
       ');
    $this->db->from(db_prefix() . $this->table_name);
    $this->db->join(db_prefix() .'staff',db_prefix() . $this->table_name.'.user_id = staffid','LEFT');
    $this->db->join(db_prefix() .'hr_employees','id_staff = staffid','LEFT');
    $this->db->join(db_prefix() .'staff staff_from','staff_from.staffid = ' . db_prefix() . 'hr_complaints.from_user_id','LEFT');



    if ($id) {
      $this->db->where('hr_complaints.id', $id);
      return $this->db->get()->row();
    }
    $this->db->order_by(db_prefix() . $this->table_name.'date', 'desc');
    $query = $this->db->get();
    return $query->result_array();
  }

  /**
   * Delete employee
   *
   * @param int $id
   *
   * @return bool
   */
  public function delete($id)
  {

    $this->db->where('id', (int)$id);
    $this->db->delete(db_prefix() . $this->table_name);

    return $this->db->affected_rows() > 0;
  }
}
