<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Employees_model
 */
class Employees_model extends App_Model
{
    public $table_name = 'hr_employees';

    /**
     * Create new employee
     *
     * @param array $data

     * @return int
     */
    public function add($data)
    {
        if (is_staff_logged_in()) {
            $data['addedfrom'] = get_staff_user_id();
        }

        $this->db->insert(db_prefix().$this->table_name, $data);

        $employee_id = $this->db->insert_id();
        $log = 'ID: ' . $employee_id;

        $isStaff = null;
        if (!is_client_logged_in() && is_staff_logged_in()) {
            $log     .= ', From Staff: ' . get_staff_user_id();
            $isStaff = get_staff_user_id();
        }

        log_activity('New Client Created [' . $log . ']', $isStaff);

        return $employee_id;
    }

    /**
     * Update employye informations
     *
     * @param array $_POST data
     * @param integer ID
     *
     * @return boolean
     */
    public function update($data, $id)
    {

        if($this->get_employee_entry_by_staff_id($id)){
          $this->db->where('id_staff', $id);
          $this->db->update(db_prefix() . $this->table_name, $data);
          log_activity('Employee Info Updated [ID: ' . $id . ']');

          return true;
        }else{
          if (is_staff_logged_in()) {
              $data['addedfrom'] = get_staff_user_id();
          }

          $data['id_staff'] = $id;
          $this->db->insert(db_prefix().$this->table_name, $data);
          return true;
        }

    }

    /**
     * Get employee
     *
     * @param int|null $id
     * @return array
     */
    public function get($id = null){
        $id = is_numeric($id) ? (int)$id : null;

        if ($id) {

            $this->db->select("*,
                (CASE WHEN ISNULL(staffid) THEN ".db_prefix()."hr_employees.firstname ELSE ".db_prefix()."staff.firstname END
                ) as firstname,
                (CASE WHEN ISNULL(staffid) THEN ".db_prefix()."hr_employees.lastname ELSE ".db_prefix()."staff.lastname END
                ) as lastname
               ");
            $this->db->from(db_prefix() . 'staff');
            $this->db->join(db_prefix() .'hr_employees','id_staff = staffid','LEFT');
            $this->db->where('staffid',(int)$id);
            $query = $this->db->get();
            return $query->row();
            //$this->db->where('id', (int)$id);
            //return $this->db->get(db_prefix() . $this->table_name)->row();
        }

            $this->db->select("*,
                (CASE WHEN ISNULL(staffid) THEN ".db_prefix()."hr_employees.firstname ELSE ".db_prefix()."staff.firstname END
                ) as firstname,
                (CASE WHEN ISNULL(staffid) THEN ".db_prefix()."hr_employees.lastname ELSE ".db_prefix()."staff.lastname END
                ) as lastname
               ");
            $this->db->from(db_prefix() . 'staff');
            $this->db->join(db_prefix() .'hr_employees','id_staff = staffid','LEFT');
            $this->db->order_by(db_prefix().'staff.firstname', 'asc');
            $this->db->order_by(db_prefix().'staff.lastname', 'asc');
            $query = $this->db->get();
            return $query->result_array();




    }

  /**
   * Get employee
   *
   * @param int|null $id
   * @return array
   */
  public function getWithout($id)
  {
    $this->db->select("*,
        (CASE WHEN ISNULL(staffid) THEN ".db_prefix()."hr_employees.firstname ELSE ".db_prefix()."staff.firstname END
        ) as firstname,
        (CASE WHEN ISNULL(staffid) THEN ".db_prefix()."hr_employees.lastname ELSE ".db_prefix()."staff.lastname END
        ) as lastname
       ");
    $this->db->from(db_prefix() . 'staff');
    $this->db->join(db_prefix() .'hr_employees','id_staff = staffid','LEFT');
    if ($id) {
      $this->db->where('staff.staffid != '.(int)$id);
    }
    $this->db->order_by(db_prefix().'staff.firstname', 'asc');
    $this->db->order_by(db_prefix().'staff.lastname', 'asc');
    $query = $this->db->get();
    return $query->result_array();

  }


public function get_employee_entry_by_staff_id($id){
  $this->db->select("*");
  $this->db->from(db_prefix() . 'hr_employees');
  $this->db->where('id_staff',(int)$id);
  $query = $this->db->get();
  return $query->row();
}


    /**
     * Delete employee
     *
     * @param int $id
     * @return bool
     */
    public function delete($id)
    {

        $this->db->where('id', (int)$id);
        $this->db->delete(db_prefix() . $this->table_name);

        return $this->db->affected_rows() > 0;
    }
}
