<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Shift_days_model
 */
class Shift_days_model extends App_Model
{

  public $table_name = 'hr_shift_days';

  /**
   * Create new employee
   *
   * @param array $data
   *
   * @return int
   */
  public function add($data)
  {
    $this->db->insert(db_prefix() . $this->table_name, $data);

    $id  = $this->db->insert_id();

    return $id;
  }

  /**
   * Update employye informations
   *
   * @param array $_POST data
   * @param integer ID
   *
   * @return boolean
   */
  public function update($data, $id)
  {
    $this->db->where('id', $id);

    $this->db->update(db_prefix() . $this->table_name, $data);

    return false;
  }

  /**
   * Get employee
   *
   * @param int|null $id
   *
   * @return array
   */
  public function get($id = null)
  {
    $id = is_numeric($id) ? (int)$id : null;
    if ($id) {
      $this->db->where('id', (int)$id);

      return $this->db->get(db_prefix() . $this->table_name)->row();
    }

    $this->db->order_by('day', 'asc');

    return $this->db->get(db_prefix() . $this->table_name)->result_array();
  }

  public function getByDay($day)
  {

    $this->db->where('day', (int)$day);

    return $this->db->get(db_prefix() . $this->table_name)->row();
  }

  public function getByShift($shift)
  {
    $shifts = [];

    $this->db->where('shift_id', (int)$shift);
    $shift_days = array_filter((array)$this->db->get(db_prefix() . $this->table_name)->result_array());

    foreach ($shift_days as $shift_day){
      $shifts[$shift_day['day']] = (object)$shift_day;
    }

    return $shifts;
  }

  /**
   * Delete employee
   *
   * @param int $id
   *
   * @return bool
   */
  public function delete($id)
  {

    $this->db->where('id', (int)$id);
    $this->db->delete(db_prefix() . $this->table_name);

    return $this->db->affected_rows() > 0;
  }

  /**
   * Delete employee
   *
   * @param int $id
   *
   * @return bool
   */
  public function deleteByShift($id)
  {

    $this->db->where('shift_id', (int)$id);
    $this->db->delete(db_prefix() . $this->table_name);

    return $this->db->affected_rows() > 0;
  }
}
