<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Workshop_users_model
 */
class Workshop_users_model extends App_Model
{

  public $table_name = 'hr_workshop_employees';

  /**
   * Create new workshop user
   *
   * @param array $data
   *
   * @return int
   */
  public function add($data)
  {
    $this->db->insert(db_prefix() . $this->table_name, $data);

    $id  = $this->db->insert_id();
    $log = 'ID: ' . $id;

    $isStaff = null;
    if (!is_client_logged_in() && is_staff_logged_in()) {
      $log     .= ', From Staff: ' . get_staff_user_id();
      $isStaff = get_staff_user_id();
    }

    log_activity('New Workshop user Created [' . $log . ']', $isStaff);

    return $id;
  }

  /**
   * Update user informations
   *
   * @param array $_POST data
   * @param integer ID
   *
   * @return boolean
   */
  public function update($data, $id)
  {
    $this->db->where('id', $id);

    $this->db->update(db_prefix() . $this->table_name, $data);

    if ($this->db->affected_rows() > 0) {
      log_activity('Workshop user Info Updated [ID: ' . $id . ']');

      return true;
    }

    return false;
  }

  /**
   * Get workshop user
   *
   * @param int|null $id
   *
   * @return array
   */
  public function get($id)
  {

    $this->db->where('id', (int)$id);

    return $this->db->get(db_prefix() . $this->table_name)->row();
  }

  /**
   * Get workshop user
   *
   * @param int|null $id
   *
   * @return array
   */
  public function getAllByWorkshopId($id, $only_user_id = true)
  {
    $result = [];
    $this->db->where('workshop_id', (int)$id);

    $this->db->join(db_prefix().'hr_employees', db_prefix().$this->table_name.'.user_id='.db_prefix().'hr_employees.id', 'left');
    $users = $this->db->get(db_prefix() . $this->table_name)->result_array();

    if($only_user_id){
      foreach ($users as $user){
        $result[] = $user['user_id'];
      }
    }

    return $only_user_id ? $result : $users;
  }

  public function getAll()
  {

    $this->db->order_by('name', 'asc');

    return $this->db->get(db_prefix() . $this->table_name)->result_array();
  }

  /**
   * Delete workshop user
   *
   * @param int $id
   *
   * @return bool
   */
  public function delete($id)
  {

    $this->db->where('id', (int)$id);
    $this->db->delete(db_prefix() . $this->table_name);

    return $this->db->affected_rows() > 0;
  }

  /**
   * Delete workshop user
   *
   * @param int $id
   *
   * @return bool
   */
  public function deleteByWorkshopId($id)
  {

    $this->db->where('workshop_id', (int)$id);
    $this->db->delete(db_prefix() . $this->table_name);

    return $this->db->affected_rows() > 0;
  }
}
