<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Class Workshops_model
 */
class Workshops_model extends App_Model
{

  public $table_name = 'hr_workshops';

  /**
   * Create new document
   *
   * @param array $data
   *
   * @return int
   */
  public function add($data)
  {
    if (is_staff_logged_in()) {
      $data['addedfrom'] = get_staff_user_id();
    }

    $users = isset($data['user_id']) ? $data['user_id'] : [];

    unset($data['user_id']);

    $data['date_start'] = date('Y-m-d', strtotime($data['date_start']));
    $data['date_end']   = date('Y-m-d', strtotime($data['date_end']));

    $this->db->insert(db_prefix() . $this->table_name, $data);

    $id  = $this->db->insert_id();
    $log = 'ID: ' . $id;

    $isStaff = null;
    if (!is_client_logged_in() && is_staff_logged_in()) {
      $log     .= ', From Staff: ' . get_staff_user_id();
      $isStaff = get_staff_user_id();
    }

    $this->addUsers($users, $id);

    log_activity('New Workshop Created [' . $log . ']', $isStaff);

    return $id;
  }

  /**
   * Update employye informations
   *
   * @param array $_POST data
   * @param integer ID
   *
   * @return boolean
   */
  public function update($data, $id)
  {
    $this->db->where('id', $id);

    $data['date_start'] = date('Y-m-d', strtotime($data['date_start']));
    $data['date_end']   = date('Y-m-d', strtotime($data['date_end']));

    $users = isset($data['user_id']) ? $data['user_id'] : [];

    unset($data['user_id']);

    $this->db->update(db_prefix() . $this->table_name, $data);

    $this->addUsers($users, $id);

    if ($this->db->affected_rows() > 0) {

      log_activity('Workshop Info Updated [ID: ' . $id . ']');

      return true;
    }

    return false;
  }

  /**
   * Get document
   *
   * @param int|null $id
   *
   * @return array
   */
  public function get($id)
  {
    $this->db->where('id', (int)$id);

    return $this->db->get(db_prefix() . $this->table_name)->row();
  }

  public function getAll()
  {

    $this->db->order_by('date_start', 'desc');

    return $this->db->get(db_prefix() . $this->table_name)->result_array();
  }

  /**
   * Delete document
   *
   * @param int $id
   *
   * @return bool
   */
  public function delete($id)
  {

    $this->db->where('id', (int)$id);
    $this->db->delete(db_prefix() . $this->table_name);

    $result = $this->db->affected_rows() > 0;
    if ($result){
      $CI =& get_instance();
      $CI->load->model('workshop_users_model');
      $CI->workshop_users_model->deleteByWorkshopId($id);
    }

    return $result;
  }

  public function addUsers($data, $id)
  {

    $id = is_numeric($id) ? (int)$id : 0;

    if (!$id) return false;

    $data = array_filter((array)$data);

    if (!count($data)) return false;
    $CI =& get_instance();
    $CI->load->model('workshop_users_model');

    $CI->workshop_users_model->deleteByWorkshopId($id);

    foreach ($data as $user_id) {
      $user_id = is_numeric($user_id) ? (int)$user_id : 0;
      if (!$user_id) continue;

      $CI->workshop_users_model->add(['user_id' => $user_id, 'workshop_id' => $id]);
    }

    return true;
  }
}
