<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/awards'); ?>"><?php echo _l('hr_awards'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="col-md-12">
                        <?php echo form_open_multipart(admin_url('hr/awards/create/' . ($award ? $award->id : 0)), ['id' => 'award-form', 'class' => ' award-form']); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col">
                                        <?php echo render_select('user_id', $employees, ['staffid', ['firstname', 'lastname']], 'hr_employee', $award ? $award->user_id : ''); ?>
                                    </div>

                                    <div class="col">
                                        <?php echo render_input('name', 'name', ($award ? $award->name : '')); ?>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col">
                                        <?php echo render_select('award_type_id', $types, ['id', ['name']], 'hr_award_type', $award ? $award->award_type_id : ''); ?>
                                    </div>
                                    <div class="col">
                                        <?php echo render_input('gift', 'hr_gift', ($award ? $award->gift : '')); ?>
                                    </div>

                                </div>

                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="img"><?php echo _l('hr_award_foto') ?></label>
                                    <input type="file" name="img" value="" id="img" class="form-control">

                                    <?php if ($award && is_file(HR_UPLOAD_AWARD_REAL . $award->img)) : ?>
                                        <br><img src="<?= HR_UPLOAD_AWARD_BASE . $award->img ?>" alt=""
                                                class="img-responsive" style="max-height: 60px">
                                        <a class="btn btn-sm btn-outline-secondary"
                                                href="<?php echo admin_url('hr/awards/removeImg/' . $award->id) ?>"><i
                                                    class="fal fa-trash text-danger"></i></a>
                                    <?php endif ?>
                                </div>

                                <?php echo render_monthyear_input('month', 'hr_award_month', ($award ? date('F Y', ($award->month != '') ? strtotime($award->month) : '') : date('F Y'))); ?>

                                <?php echo render_date_input('date', 'date', ($award ? date('Y-m-d', strtotime($award->date)) : date('Y-m-d'))); ?>
                                <?php echo render_input('cash', 'hr_cash', ($award ? $award->cash : ''), 'number', ['step="0.1"']); ?>


                            </div>
                        </div>

                        <div class="row">
                            <div class="col">
                                <?php echo render_textarea('information', 'hr_award_information', ($award ? $award->description : ''), ['rows' => 2]); ?>
                            </div>
                            <div class="col">
                                <?php echo render_textarea('description', 'description', ($award ? $award->description : ''), ['rows' => 2]); ?>
                            </div>
                        </div>

                        <div class="row pd-15 bd-t">
                            <button class="btn btn-info award-form-submit" type="submit">
                                <?php echo _l('save'); ?>
                            </button>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>