<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_hr'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <input type="hidden" class="ays-ignore" name="<?php echo $this->security->get_csrf_token_name(); ?>"
            value="<?php echo $this->security->get_csrf_hash(); ?>">
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if (has_permission('hr', '', 'create')) { ?>
                                <div class="card bd-0 shadow-base">
                                    <div class="card-body">
                                        <a href="<?php echo admin_url('hr/awards/create'); ?>"
                                                class="btn btn-info mg-r-5">
                                            <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php echo _l('hr_new_award'); ?>
                                        </a>
                                        <a href="<?php echo admin_url('hr/awards/createType'); ?>"
                                                class="btn btn-outline-secondary mg-r-5" data-target="#modal_type"
                                                data-toggle="modal">
                                            <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php echo _l('hr_new_award_type'); ?>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>

                            <?php
                            $table_data = array(
                                _l('name'),
                                _l('hr_employee'),
                                _l('type'),
                                _l('hr_gift'),
                                _l('hr_cash'),
                                _l('hr_award_month'),
                                _l('action'),
                            );

                            render_datatable($table_data, 'awards');
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view('hr/modals/awardType', ['type' => null]); ?>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    notsearchable = [6];
    notsortable = [6];
    initDataTable('.table-awards', admin_url + 'hr/awards/table_awards', notsearchable, notsortable, 'undefined');
</script>
</body>
</html>
