<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <input type="hidden" class="ays-ignore" name="<?php echo $this->security->get_csrf_token_name(); ?>"
           value="<?php echo $this->security->get_csrf_hash(); ?>">
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if (has_permission('hr', '', 'create')) { ?>
                                <div class="card bd-0 shadow-base">
                                    <div class="card-body pd-15">
                                        <a href="<?php echo admin_url('hr/awards/createType'); ?>"
                                           class="btn btn-info mg-r-5" data-target="#modal_type" data-toggle="modal">
                                            <?php echo _l('hr_new_award_type'); ?></a>
                                        <hr>
                                    </div>
                                </div>
                            <?php } ?>

                            <?php
                            $table_data = array(
                                _l('name'),
                                _l('description'),
                                _l('action'),
                            );

                            render_datatable($table_data, 'awardTypes');
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view('hr/modals/awardType', ['type' => null]); ?>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    initDataTable('.table-awardTypes', admin_url + 'hr/awards/table_awardTypes', undefined, undefined, 'undefined');
</script>
</body>
</html>