<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/checkins'); ?>"><?php echo _l('hr_checkins'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo form_open_multipart(admin_url('hr/checkins/create/' . set_value('id', $id ?? 0)),
                                ['id' => 'travel-form', 'class' => ' travel-form']); ?>
                            <div class="row">
                                <div class="col-md-12">
                                    <?php echo render_select('user_id', $employees, ['staffid', ['firstname', 'lastname']], 'staff', set_value('user_id', $user_id ?? '')); ?>
                                    <?php echo form_error('user_id', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col-md-6">
                                    <?php echo render_datetime_input('start', 'hr_start', set_value('start', isset($start) ? date('Y-m-d H:i', strtotime($start)) : date('Y-m-d H:i'))); ?>
                                    <?php echo form_error('start', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col-md-6">
                                    <?php echo render_datetime_input('end', 'hr_end', set_value('end', isset($end) ? date('Y-m-d H:i', strtotime($end)) : '')); ?>
                                    <?php echo form_error('end', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                            </div>

                            <div class="row pd-15 bd-t">
                                <button class="btn btn-info travel-form-submit" type="submit">
                                    <?php echo _l('save'); ?>
                                </button>

                                <a href="<?= base_url('admin/hr/checkins'); ?>" class="btn btn-info">
                                    <?php echo _l('back'); ?>
                                </a>

                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    $(document).ready(function () {
        $(document).on('change', '#mode', function (event) {
            event.preventDefault();
            var $is_internal = $(this).val() === 'internal';

            if ($(this).val() === '') {
                $('#trainer_name, #trainer_id').prop('disabled', 1);
                $('#trainer_id').selectpicker('refresh');
                return false;
            }

            if ($is_internal) {
                $('.select_external').hide();
                $('.select_internal').show();
            } else {
                $('.select_internal').hide();
                $('.select_external').show();
            }

            $('#trainer_name').prop('disabled', $is_internal);
            $('#trainer_id').prop('disabled', !$is_internal).selectpicker('refresh', true);
        });
    });
</script>
</body>
</html>