<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/company'); ?>"><?php echo _l('hr_departments'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card bd-0 shadow-base mg-t-15">
                                <div class="card-body pd-15">
                                    <?php echo form_open_multipart(admin_url('hr/company/createDepartment/' . set_value('id', ($id != null ? $id : null)))); ?>
                                    <div class="row">
                                        <div class="col">
                                            <?php echo render_input('name', 'hr_department_name', set_value('name', $name ?? '')); ?>
                                            <?php echo form_error('name', '<div class="error text-danger">', '</div>'); ?>
                                        </div>
                                        <div class="col">
                                            <?php echo render_select('user_id', $employees, ['staffid', ['firstname', 'lastname']], 'hr_department_head', set_value('user_id', $user_id ?? '')); ?>
                                            <?php echo form_error('user_id', '<div class="error text-danger">', ' ' . _l('go_to_staff') . '</div>'); ?>
                                        </div>
                                        <div class="col">
                                            <?php echo render_select('location_id', $locations, ['id', ['name']], 'hr_location', set_value('location_id', $location_id ?? '')); ?>
                                            <?php echo form_error('location_id', '<div class="error text-danger">', ' ' . _l('go_to_company_locations') . '</div>'); ?>
                                        </div>
                                    </div>

                                    <div class="row pd-15 bd-t">
                                        <button class="btn btn-info award-form-submit" type="submit">
                                            <?php echo _l('save'); ?>
                                        </button>
                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>
