<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card bd-0 shadow-base mg-t-15">
                                <div class="card-header">
                                    <h6 class="card-title tx-uppercase tx-12 mg-b-0">
                                        <?php if (set_value('id', $id ?? 0)): ?>
                                            <?= _l('hr_edit_designation'); ?>
                                        <?php else: ?>
                                            <?= _l('hr_new_designation'); ?>
                                        <?php endif ?>
                                    </h6>
                                </div>
                                <div class="card-body pd-15">
                                    <?php echo form_open(admin_url('hr/company/createDesignation/' . set_value('id', $id ?? '')), ['id' => 'employee-form', 'class' => ' employee-form']); ?>

                                    <div class="row">
                                        <div class="col">
                                            <?php echo render_input('name', 'hr_designation_name', set_value('name', $name ?? '')); ?>
                                            <?php echo form_error('name', '<div class="error text-danger">', '</div>'); ?>
                                        </div>
                                        <div class="col">
                                            <?php echo render_input('score', 'hr_designation_score', set_value('score', $score ?? '')); ?>
                                            <?php echo form_error('score', '<div class="error text-danger">', '</div>'); ?>
                                        </div>
                                    </div>

                                    <div class="row pd-15 bd-t"><br>

                                        <button class="btn btn-info employee-form-submit" type="submit">
                                            <?php echo _l('save'); ?>
                                        </button>

                                        <a href="<?= base_url('admin/hr/company/designations'); ?>"
                                           class="btn btn-info">
                                            <?php echo _l('back'); ?>
                                        </a>

                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>
