<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/company/locations'); ?>"><?php echo _l('hr_locations'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card bd-0 shadow-base mg-t-15">
                                <div class="card-header">
                                    <h6 class="card-title tx-uppercase tx-12 mg-b-0">
                                        <?php if (set_value('id', $id ?? 0)): ?>
                                            <?= _l('hr_edit_location'); ?>
                                        <?php else: ?>
                                            <?= _l('hr_new_location'); ?>
                                        <?php endif ?>
                                    </h6>
                                </div>
                                <div class="card-body pd-15">
                                    <?php echo form_open(admin_url('hr/company/createLocation/' . set_value('id', $id ?? '')), ['id' => 'employee-form', 'class' => ' employee-form']); ?>

                                    <div class="row">
                                        <div class="col">
                                            <?php echo render_input('name', 'name', set_value('name', $name ?? '')); ?>
                                            <?php echo form_error('name', '<div class="error text-danger">', '</div>'); ?>
                                        </div>
                                        <div class="col">
                                            <?php echo render_select('user_id', $employees, ['staffid', ['firstname', 'lastname']], 'hr_department_head', set_value('user_id', $user_id ?? '')); ?>
                                            <?php echo form_error('user_id', '<div class="error text-danger">', '</div>'); ?>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col">
                                            <?php echo render_input('email', 'client_email', set_value('email', $email ?? '')); ?>
                                        </div>
                                        <div class="col">
                                            <?php echo render_input('phonenumber', 'client_phonenumber', set_value('phonenumber', $phonenumber ?? ''), 'text', array('autocomplete' => 'off')); ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <?php echo render_textarea('address', 'employee_address', set_value('address', $address ?? '')); ?>
                                    </div>
                                    <div class="row">
                                        <?php /*<div class="col">
                            <?php
                            $cities = get_all_cities_with_zones();
                            ?>
                            <?php echo render_select('city_id', $cities, ['id', ['name'], 'zone_name'], 'city', set_value('city_id', $city_id ?? '')); ?>
                          </div>*/ ?>
                                        <div class="col">
                                            <?php $countries = get_all_countries(); ?>
                                            <?php echo render_select('country_id', $countries, ['country_id', ['short_name'], 'iso2'], 'billing_country', set_value('country_id', $country_id ?? '')); ?>
                                        </div>
                                        <div class="col">
                                            <?php echo render_input('county_name', 'county_name', set_value('county_name', $county_name ?? ''), 'text', array('autocomplete' => 'off')); ?>
                                        </div>
                                        <div class="col">
                                            <?php echo render_input('city_name', 'city_name', set_value('city_name', $city_name ?? ''), 'text', array('autocomplete' => 'off')); ?>
                                        </div>
                                    </div>


                                    <div class="row pd-15 bd-t">
                                        <button class="btn btn-info employee-form-submit" type="submit">
                                            <?php echo _l('save'); ?>
                                        </button>

                                        <a href="<?= base_url('admin/hr/company/locations'); ?>" class="btn btn-info">
                                            <?php echo _l('back'); ?>
                                        </a>

                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>
