<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/documents'); ?>"><?php echo _l('hr_documents'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div>
                        <?php echo form_open_multipart(admin_url('hr/documents/create/' . set_value('id', $id ?? 0)),
                            ['id' => 'document-form', 'class' => ' document-form']); ?>
                        <div class="row">
                            <div class="col-md-4">
                                <?php echo render_input('name', 'name', set_value('name', $name ?? '')); ?>
                                <?php echo form_error('name', '<div class="error text-danger">', '</div>'); ?>
                            </div>
                            <div class="col-md-4">
                                <?php echo render_input('number', 'number', set_value('number', $number ?? '')); ?>
                                <?php echo form_error('number', '<div class="error text-danger">', '</div>'); ?>
                            </div>
                            <div class="col-md-4">
                                <?php echo render_date_input('date_expire', 'hr_date_expire', set_value('date_expire', isset($date_expire) ? date('d-m-Y', strtotime($date_expire)) : '')); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo render_select('category_id', $categories, ['id', ['name']], 'categories', set_value('category_id', $category_id ?? '')); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo render_select('type_id', $types, ['id', ['name']], 'types', set_value('type_id', $type_id ?? '')); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo render_select('user_id', $employees, ['staffid', ['firstname', 'lastname']], 'hr_employees', set_value('user_id', $user_id ?? '')); ?>
                            </div>
                            <div class="col-md-6">
                                <?php echo render_select('department_id', $departments, ['departmentid', ['name']], 'departments', set_value('department_id', $department_id ?? '')); ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 form-group">
                                <label for="file"><?php echo _l('hr_document') ?></label>
                                <input type="file" name="file" value="<?= set_value('file', $file ?? '') ?>" id="file"
                                       class="form-control">
                                <?php echo form_error('file', '<div class="error text-danger">', '</div>'); ?>
                            </div>
                            <?php if (isset($filename) && is_file(HR_UPLOAD_DOCUMENT_REAL . $filename)) : ?>
                                <?php if ($original_filename != '') {
                                    echo '<p>Uploaded file: ' . $original_filename . '</p>';
                                } else {
                                    echo '<p>Uploaded file: ' . $filename . '</p>';
                                } ?>

                                <div class="col form-group">
                                    <label for="">&nbsp;</label><br>
                                    <a href="<?php echo HR_UPLOAD_DOCUMENT_BASE . $filename ?>" target="_blank"
                                       class="btn btn-outline-secondary"><i class="fal fa-eye"></i></a>
                                    <a href="<?php echo admin_url('hr/documents/download/' . set_value('id', $id ?? 0)) ?>"
                                       alt="" class="btn btn-outline-secondary mg-l-5"><i
                                                class="fal fa-download"></i></a>
                                </div>

                            <?php endif ?>
                        </div>

                        <div class="row pd-15 bd-t">
                            <button class="btn btn-info document-form-submit" type="submit">
                                <?php echo _l('save'); ?>
                            </button>
                            <a href="<?= base_url('admin/hr/documents'); ?>"
                               class="btn btn-info document-form-submit"><?= _l('back_to') . ' ' . _l('hr_documents'); ?></a>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>
