<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_hr'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <?php $this->load->view('hr/documents/header', ['active' => 'all']); ?>


                    <div class="row">
                        <div class="col-md-12">
                            <?php if (has_permission('hr', '', 'create')) { ?>
                                <div class="form-group">
                                    <a href="<?php echo admin_url('hr/documents/create'); ?>"
                                       class="btn btn-info mg-r-5">
                                        <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php //INACTIVE:echo _l('hr_new_document'); ?>
                                    </a>
                                </div>
                            <?php } ?>
                            <?php
                            $table_data = [
                                _l('name'),
                                _l('type'),
                                _l('category'),
                                _l('department'),
                                _l('hr_employee'),
                                _l('hr_expire_date'),
                                _l('action'),
                            ];

                            render_datatable($table_data, 'documents');
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    notsearchable = [6];
    notsortable = [6];
    initDataTable('.table-documents', admin_url + 'hr/tables_hr/table_documents', notsearchable, notsortable, 'undefined', [0, 'desc']);
</script>
</body>
</html>
