<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_hr'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if (has_permission('hr', '', 'create')) { ?>
                                <a href="<?php echo admin_url('hr/employee/createComplaint'); ?>"
                                        class="btn btn-info mg-r-5">
                                    <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i>
                                </a>
                            <?php } ?>

                            <?php
                            $table_data = array(
                                _l('hr_from_employee'),
                                _l('hr_to_employee'),
                                _l('hr_title'),
                                _l('date'),
                                _l('action'),
                            );

                            render_datatable($table_data, 'complaints');
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    initDataTable('.table-complaints', admin_url + 'hr/tables_hr/table_complaints', undefined, undefined, 'undefined', [3, 'desc']);
</script>
</body>
</html>
