<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <a href="<?php echo admin_url('hr/employee/'); ?>"
                               class="btn btn-info mg-r-5"><?php echo _l('back_to_employees'); ?></a>
                            <hr>
                            <?php echo form_open(admin_url('hr/employee/createEmployee/' . ($employee ? $employee->staffid : 0)), ['id' => 'employee-form', 'class' => ' employee-form', 'autocomplete="off"']); ?>

                            <div class="row">
                                <div class="col-md-4">
                                    <?php echo render_input('firstname', 'firstname', ($employee ? $employee->firstname : '')); ?>
                                </div>
                                <div class="col-md-4">
                                    <?php echo render_input('lastname', 'lastname', ($employee ? $employee->lastname : '')); ?>
                                </div>
                                <div class="col-md-4">
                                    <?php echo render_input('employee_id', 'hr_employee_id', ($employee ? $employee->employee_id : '')); ?>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <?php echo render_select('location_id', $locations, ['id', ['name']], 'hr_location', $employee ? $employee->location_id : ''); ?>
                                </div>
                                <div class="col-md-4">
                                    <?php echo render_select('department_id', $departments, ['departmentid', ['name']], 'hr_department', $employee ? $employee->department_id : ''); ?>
                                </div>
                                <div class="col-md-4">
                                    <?php echo render_select('parent_id', $employees, ['id', ['firstname', 'lastname']], 'hr_reports_to', $employee ? $employee->parent_id : ''); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <?php $designations = $this->designations_hr_model->get(null); ?>
                                    <?php echo render_select('designation_id', $designations, ['id', ['name']], 'employee_position', $employee ? $employee->designation_id : ''); ?>
                                </div>
                                <div class="col-md-4">
                                    <?php echo render_input('email', 'client_email', $employee ? $employee->email : '', 'email'); ?>
                                </div>
                                <div class="col-md-4">
                                    <?php echo render_input('phonenumber', 'client_phonenumber', $employee ? $employee->phonenumber : '', 'text', array('autocomplete' => 'off')); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <?php echo render_select('shift_id', $shifts, ['id', ['name']], 'hr_shift', $employee ? $employee->shift_id : ''); ?>
                                </div>
                                <div class="col-md-4">
                                    <?php
                                    $cities = get_all_cities_with_zones();
                                    ?>
                                    <?php echo render_select('city_id', $cities, ['id', ['name'], 'zone_name'], 'city', $employee ? $employee->city_id : ''); ?>
                                </div>
                                <div class="col-md-4">
                                    <?php $countries = get_all_countries(); ?>
                                    <?php echo render_select('country_id', $countries, ['country_id', ['short_name'], 'iso2'], 'billing_country', $employee ? $employee->country_id : ''); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <?php echo render_textarea('address', 'employee_address', $employee ? $employee->address : ''); ?>

                                </div>

                            </div>


                            <div class="row pd-15 bd-t">
                                <button class="btn btn-info" type="submit">
                                    <?php echo _l('save'); ?>
                                </button>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    $(document).ready(function () {
        $(document).on('change', '#location_id', function (event) {
            event.preventDefault();
            var id = parseInt($(this).val()),
                $department_id = $('#department_id');
            $department_id.empty();

            if (isNaN(id)) {
                return false;
            }

            $.ajax({
                url: '<?php echo admin_url('hr/employee/getDeparments/')?>',
                type: "POST",
                data: {location_id: id}
            }).done(function (response) {
                $department_id.html(response);
            }).fail(function (response) {

            }).always(function () {
                $department_id.selectpicker('refresh');
            });
        });
    });
</script>
</body>
</html>
