<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/employee/promotions'); ?>"><?php echo _l('hr_promotions'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo form_open(admin_url('hr/employee/createPromotion/' . set_value('id', $id ?? 0)), ['id' => 'employee-form', 'class' => ' employee-form']); ?>

                            <div class="row">
                                <div class="col">
                                    <?php echo render_select('user_id', $employees, ['staffid', ['firstname', 'lastname']], 'staff', set_value('user_id', $user_id ?? '')); ?>
                                    <?php echo form_error('user_id', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col">
                                    <?php $designations = $this->designations_hr_model->get(); //get_all_designations(); ?>
                                    <?php echo render_select('designation_id', $designations, ['id', ['name']], 'employee_position', set_value('designation_id', $designation_id ?? '')); ?>
                                    <?php echo form_error('designation_id', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <?php echo render_input('title', 'hr_title', set_value('title', $title ?? ''), 'text', array('autocomplete' => 'off')); ?>
                                    <?php echo form_error('title', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col">
                                    <?php echo render_date_input('date', 'date', (set_value('description', isset($date) && $date ? date('Y-m-d', strtotime($date)) : ''))); ?>
                                    <?php echo form_error('date', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <?php echo render_textarea('description', 'description', set_value('description', $description ?? '')); ?>
                                </div>
                            </div>

                            <div class="row pd-15 bd-t">
                                <button class="btn btn-info employee-form-submit" type="submit">
                                    <?php echo _l('save'); ?>
                                </button>
                                <a href="<?= base_url('admin/hr/employee/promotions'); ?>" class="btn btn-info">
                                    <?php echo _l('back'); ?>
                                </a>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    /* $(document).ready(function(){
       $(document).on('change', '#location_id', function (event) {
         event.preventDefault();
         var id = parseInt($(this).val()),
             $department_id = $('#department_id');
         $department_id.empty();

         if(isNaN(id)){
           return false;
         }

         $.ajax({
           url: '<?php echo admin_url('hr/employee/getDeparments/')?>',
        type: "POST",
        data: {location_id: id}
      }).done(function (response) {
        $department_id.html(response);
      }).fail(function (response) {

      }).always(function () {
        $department_id.selectpicker('refresh');
      });
    });
  });*/
</script>
</body>
</html>