<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/employee/resignations'); ?>"><?php echo _l('hr_resignations'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo form_open(admin_url('hr/employee/createResignation/' . set_value('id', $id ?? 0)), ['id' => 'employee-form', 'class' => ' employee-form']); ?>

                            <div class="row">
                                <div class="col">
                                    <?php echo render_select('user_id', $employees, ['staffid', ['firstname', 'lastname']], 'staff', set_value('user_id', $user_id ?? 0)); ?>
                                    <?php echo form_error('user_id', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col">
                                    <?php echo render_date_input('date', 'hr_date_notice', set_value('date', isset($date) ? date('Y-m-d', strtotime($date)) : '')); ?>
                                    <?php echo form_error('date', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col">
                                    <?php echo render_date_input('date_resignation', 'hr_date_resignation', set_value('date_resignation', isset($date_resignation) ? date('Y-m-d', strtotime($date_resignation)) : '')); ?>
                                    <?php echo form_error('date_resignation', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <?php echo render_textarea('description', 'description', set_value('description', $description ?? '')); ?>
                                </div>
                            </div>

                            <div class="row pd-15 bd-t">
                                <button class="btn btn-info employee-form-submit" type="submit">
                                    <?php echo _l('save'); ?>
                                </button>

                                <a href="<?= base_url('admin/hr/employee/resignations'); ?>" class="btn btn-info">
                                    <?php echo _l('back'); ?>
                                </a>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>