<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/employee/shifts'); ?>"><?php echo _l('hr_shifts'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo form_open(admin_url('hr/employee/createShift/' . set_value('id', $id ?? 0)),
                                ['id' => 'employee-form', 'class' => ' employee-form']); ?>
                            <?php echo render_input('name', 'name', set_value('name', $name ?? '')); ?>
                            <?php echo form_error('name', '<div class="error text-danger">', '</div>'); ?>
                            <?php foreach (range(1, 7) as $day_c) : ?>
                                <?php $shift_day = isset($days[$day_c]) ? $days[$day_c] : null;


                                ?>
                                <div class="row align-items-center">
                                    <div class="col-2">
                                        <h4><?php echo strftime('%A', strtotime("Sunday +{$day_c} days")); ?></h4>
                                    </div>
                                    <div class="col">
                                        <?php echo render_input('days[' . $day_c . '][start]', 'hr_start', (isset($shift_day) ? date('H:i', strtotime($shift_day->start)) : ''), 'time', [], [], ''); ?>
                                    </div>
                                    <div class="col">
                                        <?php echo render_input('days[' . $day_c . '][end]', 'hr_end', (isset($shift_day) ? date('H:i', strtotime($shift_day->end)) : ''), 'time', [], [], ''); ?>
                                    </div>
                                </div>
                            <?php endforeach ?>
                            <div class="row pd-15 bd-t">
                                <button class="btn btn-info employee-form-submit" type="submit">
                                    <?php echo _l('save'); ?>
                                </button>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script src="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js"></script>
</body>
</html>