<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/employee/terminations'); ?>"><?php echo _l('hr_terminations'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo form_open(admin_url('hr/employee/createTermination/'),
                                ['id' => 'employee-form', 'class' => ' employee-form']); ?>

                            <div class="row">
                                <div class="col">
                                    <?php echo render_select('user_id', $employees, ['staffid', ['firstname', 'lastname']], 'user_id', set_value('user_id', $user_id ?? '')); ?>
                                    <?php echo form_error('user_id', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col margintop25">
                                    <?php echo render_date_input('date', 'hr_date_notice', set_value('date', isset($date) && $date ? date('d-m-Y', strtotime($date)) : '')); ?>
                                    <?php echo form_error('date', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col margintop25">
                                    <?php echo render_date_input('date_finish', 'hr_date_termination', set_value('date_finish', isset($date_finish) && $date_finish ? date('d-m-Y', strtotime($date_finish)) : '')); ?>
                                    <?php echo form_error('date_finish', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col margintop25">
                                    <?php echo render_select('type_id', $types, ['id', ['name']], 'hr_type', set_value('type_id', $type_id ?? '')); ?>
                                    <?php echo form_error('type_id', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col margintop25">
                                    <?php echo render_textarea('description', 'description', set_value('description', $description ?? '')); ?>
                                </div>
                            </div>

                            <div class="row margintop25 pd-15 bd-t">
                                <button class="btn btn-info employee-form-submit" type="submit">
                                    <?php echo _l('save'); ?>
                                </button>

                                <a class="btn btn-info employee-form-submit"
                                   href="<?= base_url('admin/hr/employee/terminations'); ?>">
                                    <?php echo _l('back'); ?>
                                </a>

                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    $(document).ready(function () {

    });
</script>
</body>
</html>
