<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/employee/transfers'); ?>"><?php echo _l('hr_transfers'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo form_open(admin_url('hr/employee/createTransfer/' . set_value('id', $id ?? 0)), ['id' => 'employee-form', 'class' => ' employee-form']); ?>

                            <div class="row">
                                <div class="col">
                                    <?php echo render_select('user_id', $employees, ['staffid', ['firstname', 'lastname']], 'hr_employee', set_value('user_id', $user_id ?? '')); ?>
                                    <?php echo form_error('user_id', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col">
                                    <?php echo render_date_input('date', 'date', set_value('date', isset($date) ? date('Y-m-d', strtotime($date)) : date('Y-m-d'))); ?>
                                    <?php echo form_error('date', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <?php echo render_select('location_id', $locations, ['id', ['name']], 'hr_location', set_value('location_id', $location_id ?? '')); ?>
                                    <?php echo form_error('location_id', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col">
                                    <?php echo render_select('department_id', $departments, ['departmentid', ['name']], 'hr_department', set_value('department_id', $department_id ?? '')); ?>
                                    <?php echo form_error('department_id', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <?php echo render_textarea('description', 'description', set_value('description', $description ?? '')); ?>
                                    <?php echo form_error('description', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                            </div>

                            <div class="row pd-15 bd-t">
                                <button class="btn btn-info employee-form-submit" type="submit">
                                    <?php echo _l('save'); ?>
                                </button>

                                <a href="<?= base_url('admin/hr/employee/transfers'); ?>" class="btn btn-info">
                                    <?php echo _l('back'); ?>
                                </a>

                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    /*$(document).ready(function(){
      $(document).on('change', '#location_id', function (event) {
        event.preventDefault();
        var id = parseInt($(this).val()),
            $department_id = $('#department_id');
        $department_id.empty();

        if(isNaN(id)){
          return false;
        }

        $.ajax({
          url: '<?php echo admin_url('hr/employee/getDeparments/')?>',
        type: "POST",
        data: {location_id: id}
      }).done(function (response) {
        $department_id.html(response);
      }).fail(function (response) {

      }).always(function () {
        $department_id.selectpicker('refresh');
      });
    });
  });*/
</script>
</body>
</html>