<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_hr'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if (has_permission('hr', '', 'create')) { ?>
                                <a href="<?php echo admin_url('hr/employee/createShift'); ?>"
                                   class="btn btn-info mg-r-5"> <i
                                            class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php //INACTIVE:echo _l('hr_new_shift'); ?>
                                </a>
                            <?php } ?>
                            <?php
                            $table_data = array(
                                _l('name'),
                                _l('action'),
                            );
                            render_datatable($table_data, 'shifts');
                            ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="panel_s" style="padding:0;">
                <div class="panel-body" style="padding:0;">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="X-dashcard">
                                <div class="dashcard__header border">
                                    <div class="dashcard__header_title">
                                        <?= _l('shifts_heatmap') ?>
                                    </div>
                                    <div class="dashcard__header_right_title"></div>
                                </div>
                                <div class="dashcard__body">
                                    <div class="dashcard__chart">
                                        <div id="shifts_heatmap"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script src="<?= site_url('assets/plugins/highcharts/highcharts.js') ?>"></script>
<script src="<?= site_url('assets/plugins/highcharts/modules/heatmap.js') ?>"></script>
<script src="<?= site_url('assets/plugins/highcharts/modules/exporting.js') ?>"></script>
<script src="<?= site_url('assets/plugins/highcharts/modules/export-data.js') ?>"></script>
<script src="<?= site_url('assets/plugins/highcharts/modules/accessibility.js') ?>"></script>

<script>
    notsearchable = [1];
    notsortable = [1];
    initDataTable('.table-shifts', admin_url + 'hr/tables_hr/table_shifts', notsearchable, notsortable, 'undefined');

    function getPointCategoryName(point, dimension) {
        var series = point.series,
            isY = dimension === 'y',
            axis = series[isY ? 'yAxis' : 'xAxis'];
        return axis.categories[point[isY ? 'y' : 'x']];
    }

    //$(document).ready(function() {

    const shifts_heatmap = Highcharts.chart('shifts_heatmap', {
        chart: {
            type: 'heatmap',
            marginTop: 40,
            marginBottom: 80,
            plotBorderWidth: 0,
            gridLineColor: '#e9ecef'
        },
        title: {
            text: 'Employee per weekday'
        },

        credits: false,
        //legend: false,
        //tooltip: false,
        xAxis: {

            categories: ['6-7', '7-8', '8-9', '9-10', '10-11', '11-12', '12-13', '13-14', '14-15', '15-16', '16-17', '17-18', '18-19', '19-20', '20-21', '21-22', '22-23', '23-24', '00-01', '01-02', '02-03', '03-04', '04-05', '05-06']
        },

        yAxis: {
            categories: ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'],
            title: null,
            reversed: true,
            gridLineColor: '#e9ecef'
        },

        accessibility: {
            point: {
                descriptionFormatter: function (point) {
                    var ix = point.index + 1,
                        xName = getPointCategoryName(point, 'x'),
                        yName = getPointCategoryName(point, 'y'),
                        val = point.value;
                    return ix + '. ' + xName + ' sales ' + yName + ', ' + val + '.';
                }
            }
        },

        colorAxis: {
            min: 0,
            minColor: '#FFFFFF',
            maxColor: Highcharts.getOptions().colors[0]
        },

        legend: false,/*{
        align: 'right',
        layout: 'vertical',
        margin: 0,
        verticalAlign: 'top',
        y: 25,
        symbolHeight: 280
    },*/

        tooltip: {
            formatter: function () {
                return '<b>' + getPointCategoryName(this.point, 'y') + 's between ' + getPointCategoryName(this.point, 'x') + '</b>';
            }
        },

        series: [{
            name: 'Working shifts',
            borderWidth: 1,
            borderColor: '#e9ecef',//culoarea in interior
            data: <?= json_encode($work_hours_no_idx) ?> <?php /*[
            //fiecare linie e intervalul orar pe verticala chartului
            //fiecare verticala de aici e linia orizontala a chartului - prima linie din chart este prima coloana de aici
            // [ora, ziua sapt -1 fata de mysql, numar]
            [0, 0, 10], [0, 1, 19], [0, 2, 8], [0, 3, 24], [0, 4, 67],
            [1, 0, 92], [1, 1, 58], [1, 2, 78], [1, 3, 117], [1, 4, 48],
            [2, 0, 35], [2, 1, 15], [2, 2, 123], [2, 3, 64], [2, 4, 52],
            [3, 0, 72], [3, 1, 132], [3, 2, 114], [3, 3, 19], [3, 4, 16],
            [4, 0, 38], [4, 1, 5], [4, 2, 8], [4, 3, 117], [4, 4, 115],
            [5, 0, 88], [5, 1, 32], [5, 2, 12], [5, 3, 6], [5, 4, 120],
            [6, 0, 13], [6, 1, 44], [6, 2, 88], [6, 3, 98], [6, 4, 96],
            [7, 0, 31], [7, 1, 1], [7, 2, 82], [7, 3, 32], [7, 4, 30],
            [8, 0, 85], [8, 1, 97], [8, 2, 123], [8, 3, 64], [8, 4, 84],
            [9, 0, 47], [9, 1, 114], [9, 2, 31], [9, 3, 48], [9, 4, 91],
            [9, 0, 47], [9, 1, 114], [9, 2, 31], [9, 3, 48], [9, 4, 91],
            [9, 0, 47], [9, 1, 114], [9, 2, 31], [9, 3, 48], [9, 4, 91]

        ]*/?>,

            dataLabels: {
                enabled: false,
                color: '#000000'
            }
        }],

        responsive: {
            rules: [{
                condition: {
                    maxWidth: 1500
                },
                chartOptions: {
                    yAxis: {
                        labels: {
                            formatter: function () {
                                return this.value.charAt(0);
                            }
                        }
                    }
                }
            }]
        }

    });

    //});
</script>
</body>
</html>
