<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_hr'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if (has_permission('hr', '', 'create')) { ?>
                                <a href="<?php echo admin_url('hr/employee/createTermination'); ?>"
                                   class="btn btn-info mg-r-5"> <i
                                            class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php echo _l('hr_new_termination'); ?>
                                </a>
                                <button class="btn btn-outline-secondary mg-r-5" data-target="#modal_type"
                                        data-toggle="modal"><i
                                            class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php echo _l('hr_new_termination_type'); ?>
                                </button>
                            <?php } ?>
                            <?php
                            $table_data = array(
                                _l('hr_employee'),
                                _l('hr_date_notice'),
                                _l('hr_date_termination'),
                                _l('action'),
                            );
                            render_datatable($table_data, 'terminations');
                            ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view('hr/modals/terminationsType', ['type' => null]); ?>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    notsearchable = [3];
    notsortable = [3];
    initDataTable('.table-terminations', admin_url + 'hr/tables_hr/table_terminations', notsearchable, notsortable, 'undefined');
    $(document).ready(function () {
        $(document).on('submit', '#type-form', function (event) {
            event.preventDefault();
            var $form = $(this),
                $btn = $form.find('button[type="submit"]').button('loading');

            if ($form.find('input[name="name"]').val() === '') {
                return false;
            }

            $.ajax({
                url: $form.attr('action'),
                type: "POST",
                data: $form.serialize()
            }).done(function (response) {
                response = JSON.parse(response);
                if (response.status == 'success') {
                    $('#name').val(response.type.name);
                    $('#description').val(response.type.description);
                    $('#modal_type').modal('hide');
                }
            }).fail(function (response) {

            }).always(function () {
                $btn.button('reset');
            });
        });
    });
</script>
</body>
</html>
