<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_hr'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if (has_permission('hr', '', 'create')) { ?>
                                <div class="card bd-0 shadow-base">
                                    <div class="card-body pd-15">
                                        <a href="<?php echo admin_url('hr/employee/createTransfer'); ?>"
                                                class="btn btn-info mg-r-5">
                                            <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php //INACTIVE:echo _l('hr_new_transfer'); ?>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                            <?php
                            $table_data = array(
                                _l('date'),
                                _l('hr_employee'),
                                _l('hr_location'),
                                _l('hr_department'),
                                _l('action'),
                            );

                            render_datatable($table_data, 'transfers');
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    notsearchable = [4];
    notsortable = [4];
    initDataTable('.table-transfers', admin_url + 'hr/tables_hr/table_transfers', notsearchable, notsortable, 'undefined');
</script>
</body>
</html>
