<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div class="br-mainpanel">
    <div class="d-block ht-1"></div>
    <div class="br-pagebody mg-b-100">
        <div class="card bd-0 shadow-base">
            <div class="card-header">
                <a data-toggle="tooltip" title="<?= _l('appointment_public_url'); ?>" class="btn btn-outline-info"
                   href="<?= $appointment['public_url']; ?>" target="_blank">
                    <i class="fal fa-external-link" aria-hidden="true"></i>
                </a>
                <?php if (staff_can('edit', 'appointments')) { ?>
                    <?php if ($appointment['finished'] == 0 && $appointment['cancelled'] == 0) { ?>
                        <button class="btn btn-primary  mg-l-5" type="submit" onClick="markAppointmentAsFinished()"
                                id="markAsFinished"><?= _l('appointment_mark_as_finished'); ?></button>

                    <?php } ?>

                    <?php if ($appointment['cancelled'] == 0 && $appointment['finished'] == 0) { ?>
                        <button class="btn btn-outline-danger mg-l-20" type="submit" onClick="cancelAppointment()"
                                id="cancelAppointment"><?= _l('appointment_cancel'); ?></button>

                    <?php } ?>

                    <?php if ($appointment['cancelled'] == 1 && $appointment['finished'] == 0) { ?>
                        <button class="btn btn-primary" type="submit" onClick="markAppointmentAsOngoing()"
                                id="markAppointmentAsOngoing"><?= _l('appointment_mark_as_ongoing'); ?></button>

                    <?php } ?>

                <?php } ?>

                <?php if (staff_can('delete', 'appointments')) { ?>

                    <a class="btn btn-danger mg-l-5" id="confirmDelete" data-toggle="tooltip"
                       title="<?= _l('appointment_dismiss_meeting'); ?>"
                       href="<?= admin_url('appointly/appointments/delete/' . $this->input->get('appointment_id')); ?>"
                       onclick="if(confirm('<?= _l('appointment_are_you_sure'); ?>')){ disableButtonsAfterDelete(); }"><?= _l('delete'); ?></a>

                <?php }

                if ($appointment['google_calendar_link'] !== null && $appointment['google_added_by_id'] == get_staff_user_id()) { ?>

                    <a data-toggle="tooltip" title="<?= _l('appointment_open_google_calendar'); ?>"
                       href="<?= $appointment['google_calendar_link']; ?>" target="_blank"
                       class="btn btn-primary-google"><i class="fa fa-google" aria-hidden="true"></i></a>

                <?php } ?>

                <?php if (staff_can('view', 'appointments') || staff_can('view_own', 'appointments')) : ?>
                    <a href="<?= admin_url('appointly/appointments'); ?>"
                       class="btn btn-outline-secondary btn-xs float-right appointment_go_back">
                        <?= _l('go_back'); ?></a>
                <?php endif; ?>
            </div>
        </div>
        <?
        $bg = $label = '';
        if ($appointment['cancelled']) {
            $bg = 'bg-danger';
            $label = strtoupper(_l('appointment_cancelled'));
        } else if (
            !$appointment['finished']
            && !$appointment['cancelled']
            && !$appointment['approved']
            && date('Y-m-d H:i', strtotime($appointment['date'] . ' ' . $appointment['start_hour'])) < date('Y-m-d H:i')
        ) {
            $bg = 'bg-danger';
            $label = strtoupper(_l('appointment_missed_label'));
        } else if (
            !$appointment['finished']
            && !$appointment['cancelled']
            && $appointment['approved'] == 1
        ) {
            $bg = 'bg-info';
            $label = strtoupper(_l('appointment_upcoming'));
        } else if (
            !$appointment['finished']
            && !$appointment['cancelled']
            && $appointment['approved'] == 0
        ) {
            $bg = 'bg-warning';
            $label = strtoupper(_l('appointment_pending_approval'));
            if (
                $appointment['approved'] == 0
                && $appointment['cancelled'] == 0
                && is_admin() || $appointment['approved'] == 0
                && $appointment['cancelled'] == 0
                && staff_can('view', 'appointments')
            ) {
                $bg = 'bg-info';
                $label
                    = '<a class="approve_appointment_single" onClick="disableButtonsAfterDelete()" href="' . admin_url('appointly/appointments/approve?appointment_id=' . $appointment['id']) . '">' . _l('appointment_approve') . '</a>';
            }
        } else {
            $bg = 'bg-success';
            $label = strtoupper(_l('appointment_finished'));
        }
        ?>
        <div class="card bd-0 shadow-base mg-t-15">
            <div class="card-header <?= $bg ?> tx-white">
                <div class="row">
                    <div class="col">
                        <h6 class="card-title tx-white tx-uppercase tx-12 mg-b-0"><?= _l('appointment_overview'); ?></h6>
                    </div>
                    <div class="col text-right tx-white">
                        <?= $label ?>
                    </div>
                </div>
            </div>
            <div class="card-body pd-15">

                <?php if ($appointment['cancel_notes'] !== null && $appointment['finished'] != 1) : ?>

                    <?php if ($appointment['cancelled'] == 0) : ?>
                        <span class="label label-danger label-big mbot20"><a class="text-white"
                                                                             href="#cancelAppointment"><?= _l('appointment_request_cancellation'); ?></a></span>
                        <br>
                    <?php endif; ?>

                    <label class="label label-warning label-big label_canceL_notes_parent">
                        <strong><?= _l('appointment_cancellation_description_label'); ?>:</strong>
                        <span class="meeting_cancel_notes_client"><?= $appointment['cancel_notes']; ?></span>
                    </label>

                <?php endif; ?>
                <div class="row">
                    <div class="col-lg-6 col-xs-12">
                        <table class="table table-bordered">
                            <tr>
                                <th colspan="2"><?= _l('appointment_general_info'); ?></th>
                            </tr>
                            <tr>
                                <th>
                                    <?= _l('appointment_initiated_by'); ?>
                                </th>
                                <th>
                                    <?=
                                    ($appointment['created_by'])
                                        ? get_staff_full_name($appointment['created_by'])
                                        : $appointment['name'];
                                    ?>
                                </th>
                            </tr>
                            <tr>
                                <th><?= _l('appointment_subject'); ?></th>
                                <td><?= $appointment['subject']; ?></td>
                            </tr>
                            <tr>
                                <th><?= _l('appointment_description'); ?></th>
                                <td><?= $appointment['description']; ?></td>
                            </tr>
                            <tr>
                                <th><?= _l('appointment_meeting_time'); ?></th>
                                <td><?= _d($appointment['date']); ?></td>
                            </tr>
                            <tr>
                                <th><?= _l('appointment_squeduled_at_text'); ?></th>
                                <td><?= date("H:i A", strtotime($appointment['start_hour'])); ?></td>
                            </tr>
                            <tr>
                                <th><?= _l('appointment_staff_attendees'); ?></th>
                                <td>
                                    <?php if (!empty($appointment['attendees'])) {

                                        foreach ($appointment['attendees'] as $staff) : ?>

                                            <a target="_blank"
                                               href="<?= admin_url() . 'profile/' . $staff['staffid']; ?>">
                                                <img src="<?= staff_profile_image_url($staff['staffid'], 'small'); ?>"
                                                     data-toggle="tooltip"
                                                     data-title="<?= $staff['firstname'] . ' ' . $staff['lastname']; ?>"
                                                     class="wd-32 rounded-circle mg-r-5" data-original-title=""
                                                     title="<?= $staff['firstname'] . ' ' . $staff['lastname'] ?>">
                                            </a>

                                        <?php endforeach; ?>

                                    <?php } else { ?>
                                        <strong> - &nbsp; <?= _l('appointment_no_assigned_staff_found'); ?></strong>
                                    <?php } ?>
                                </td>
                            </tr>
                            <?php if (
                                $appointment['reminder_before_type'] !== null
                                && $appointment['reminder_before'] !== null
                                && $appointment['approved'] == 1
                            ) { ?>
                                <tr>
                                    <th colspan="2"><?= _l('appointment_notified'); ?></th>
                                </tr>
                                <tr>
                                    <th><?= _l('appointment_notified_by_sms'); ?>
                                        &nbsp;<small><?= _l('appointments_applies_for_clients'); ?></small></th>
                                    <td><?= ($appointment['notification_date'] !== null && $appointment['by_sms']) ? _l('appointment_yes') : _l('appointment_no'); ?></td>
                                </tr>
                                <tr>
                                    <th><?= _l('appointment_notified_by_email'); ?></th>
                                    <td><?= ($appointment['notification_date'] !== null && $appointment['by_email']) ? _l('appointment_yes') : _l('appointment_no'); ?></td>
                                </tr>
                                <?php if ($appointment['notification_date'] !== null) : ?>
                                    <tr>
                                        <th><?= _l('appointment_notified_at'); ?></th>
                                        <td><?= _dt($appointment['notification_date']); ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if (
                                    $appointment['reminder_before_type'] !== null
                                    && $appointment['reminder_before'] !== null
                                    && $appointment['approved'] == 1
                                ) { ?>
                                    <tr>
                                        <th colspan="2">
                                            <button data-toggle="tooltip"
                                                    title="<?= _l('appointment_manually_send_reminders_info'); ?>"
                                                    class="btn btn-outline-primary btn-xs"
                                                    type="submit"
                                                    onClick="sendAppointmentReminders()"
                                                    id="sendAppointmentReminders"><?= _l('appointment_send_early_reminders_label'); ?></button>
                                        </th>
                                    </tr>

                                <?php } ?>

                            <?php } ?>
                        </table>
                    </div>
                    <div class="col-lg-6 col-xs-12">
                        <table class="table table-bordered">
                            <tr>
                                <th colspan="2"><?= _l('appointment_additional_info'); ?></th>
                            </tr>
                            <tr>
                                <th><?= _l('appointment_source'); ?></th>
                                <td><?= !isset($appointment['details']) ? _l('appointment_source_external_text') : _l('appointment_source_internal'); ?></td>
                            </tr>
                            <tr>
                                <th><?= _l('appointment_name'); ?></th>
                                <td><?= isset($appointment['name']) ? $appointment['name'] : $appointment['details']['full_name']; ?></td>
                            </tr>
                            <tr>
                                <th><?= _l('appointment_email'); ?></th>
                                <td>
                                    <?php $mail_to = isset($appointment['email']) ? $appointment['email'] : $appointment['details']['email']; ?>
                                    <a class="tx-inverse tx-medium tx-12"
                                       href="mailto:<?= $mail_to; ?>"><?= $mail_to; ?>
                                </td>
                            </tr>
                            <tr>
                                <th><?= _l('appointment_phone'); ?></th>
                                <td>
                                    <?php
                                    $phoneToCall = isset($appointment['details']['phone'])
                                        ? ($appointment['details']['phone'])
                                        : ($appointment['phone'])
                                            ? $appointment['phone']
                                            : '';
                                    ?>
                                    <?php if ($phoneToCall) : ?>
                                        <a data-toggle="tooltip" class="btn btn-xs btn-outline-secondary"
                                           title="<?= _l('appointment_send_an_sms'); ?>"
                                           href="sms:<?= $phoneToCall; ?>&body=Hello">SMS: <?= $phoneToCall; ?></a>
                                        <a data-toggle="tooltip" class="btn btn-xs btn-outline-secondary mg-l-5"
                                           title="<?= _l('appointment_call_number') ?>"
                                           href="tel:<?= $phoneToCall; ?>">Call: <?= $phoneToCall; ?></a>

                                    <?php endif ?>
                                </td>
                            </tr>
                            <tr>
                                <th><?= _l('appointment_location_address'); ?></th>
                                <td>
                                    <?php $appAddress = $appointment['address'] ? $appointment['address'] : ''; ?>

                                    <a class="tx-inverse tx-medium tx-12" data-toggle="tooltip"
                                       title="Open in Google Maps" target="_blank"
                                       href="https://maps.google.com/?q=<?= $appAddress; ?>"><?= $appAddress; ?></a>
                                </td>
                            </tr>
                            <?php if ($appointment['type_id'] != 0) { ?>
                                <tr>
                                    <th><?= _l('appointments_type_heading'); ?></th>
                                    <td><?= get_appointment_type($appointment['type_id']); ?></td>
                                </tr>
                            <?php } ?>
                            <?php
                            if (isset($appointment['notes']) && trim($appointment['notes']) !== '') { ?>
                                <tr>
                                    <th colspan="2"><?= _l('appointment_client_notes'); ?></th>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <?= $appointment['notes']; ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="modal_wrapper"></div>
</body>
<?php init_tail(); ?>
<?php require('modules/appointly/assets/js/tables_appointment_js.php'); ?>
</html>