<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('hr/travels'); ?>"><?php echo _l('hr_travels'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo form_open_multipart(admin_url('hr/travels/create/' . set_value('id', $id ?? 0)),
                                ['id' => 'travel-form', 'class' => ' travel-form']); ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <?php echo render_select('user_id', $employees, ['staffid', ['firstname', 'lastname']], 'staff', set_value('user_id', $user_id ?? 0)); ?>
                                    <?php echo form_error('user_id', '<div class="error text-danger">', '</div>'); ?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <?php echo render_input('place', 'place', set_value('place', $place ?? '')); ?>
                                        </div>
                                        <div class="col-md-6">
                                            <?php echo render_input('scope', 'scope', set_value('scope', $scope ?? '')); ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <?php echo render_date_input('date_start', 'hr_start', set_value('date_start', isset($date_start) ? date('Y-m-d', strtotime($date_start)) : '')); ?>
                                            <?php echo form_error('date_start', '<div class="error text-danger">', '</div>'); ?>
                                        </div>
                                        <div class="col-md-6">
                                            <?php echo render_date_input('date_end', 'hr_end', set_value('date_end', isset($date_end) ? date('Y-m-d', strtotime($date_end)) : '')); ?>
                                            <?php echo form_error('date_end', '<div class="error text-danger">', '</div>'); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <?php echo render_textarea('description', 'description', set_value('description', $description ?? '')); ?>
                                    <?php echo form_error('description', '<div class="error text-danger">', '</div>'); ?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <?php echo render_input('budget', 'budget', round(set_value('budget', $budget ?? ''), 2), 'number'); ?>
                                        </div>
                                        <div class="col-md-6">
                                            <?php echo render_input('actual_budget', 'actual_budget', round(set_value('actual_budget', (isset($actual_budget) ? (int)$actual_budget : ''), ''), 2), 'number'); ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <?php echo render_select('mode_id', $modes, ['id', ['name']], 'modes', set_value('mode_id', $mode_id ?? '')); ?>
                                        </div>
                                        <div class="col-md-6">
                                            <?php echo render_select('type_id', $types, ['id', ['name']], 'types', set_value('type_id', $type_id ?? '')); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row pd-15 bd-t">
                                <button class="btn btn-info travel-form-submit" type="submit">
                                    <?php echo _l('save'); ?>
                                </button>
                                <a href="<?= base_url('admin/hr/travels'); ?>" class="btn btn-info">
                                    <?php echo _l('back'); ?>
                                </a>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>
