<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?php echo _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_hr'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo html_entity_decode($title); ?></a>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php $this->load->view('hr/workshops/header', ['active' => 'all']); ?>
                            <?php if (has_permission('hr', '', 'create')) { ?>
                                <div class="form-group">
                                    <a href="<?php echo admin_url('hr/workshops/create'); ?>"
                                       class="btn btn-info mg-r-5">
                                        <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php //INACTIVE:echo _l('hr_new_workshop'); ?>
                                    </a>
                                </div>
                            <?php } ?>
                            <?php
                            $table_data = [
                                _l('description'),
                                _l('hr_trainer_name'),
                                _l('hr_start'),
                                _l('hr_end'),
                                _l('type'),
                                _l('hr_workshop_option'),
                                _l('hr_workshop_cost'),
                                _l('action'),
                            ];

                            render_datatable($table_data, 'workshops');
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    notsearchable = [7];
    notsortable = [7];
    initDataTable('.table-workshops', admin_url + 'hr/tables_hr/table_workshops', notsearchable, notsortable, 'undefined', [2, 'DESC']);
</script>
</body>
</html>
