<?php defined('BASEPATH') or exit('No direct script access allowed');

class Marketing_campaigns extends AdminController
{

  public function __construct()
  {
    parent::__construct();
    $this->load->helper(['form', 'url']);
    $this->load->library('form_validation');
    $this->load->model('marketing_campaigns_model');

  }

  public function index()
  {
    if (!has_permission('marketing_campaigns', '', 'view')) {
        access_denied('marketing_campaigns');
    }
    $data['title'] = _l('marketing_campaigns');

    $this->load->view('marketing_campaigns/manage', $data);
  }

  public function campaign($id = null)
  {

    if (!has_permission('marketing_campaigns', '', 'view')) {
      access_denied('marketing_campaigns');
    }

    if ($this->input->post() && !$this->input->is_ajax_request()) {
      $data = $this->input->post();
      $this->form_validation->set_rules('start', _l('marketing_campaigns'), 'required');
      $this->form_validation->set_rules('end', _l('marketing_campaigns'), 'required');
      if ($this->form_validation->run() === true) {
        if (!$id) {
          $id = $this->marketing_campaigns_model->add($data);

          if ($id) {
            set_alert('success', _l('added_successfully', _l('marketing_campaigns')));
          }
        } else {
          $success = $this->marketing_campaigns_model->update($data, $id);
          if ($success == true) {
            set_alert('success', _l('updated_successfully', _l('marketing_campaigns')));
          }
        }
        redirect(admin_url('marketing_campaigns/campaign/' . $id));
      }
    }
    $marketing_campaign = null;

    if ($id) {
      $marketing_campaign = $this->marketing_campaigns_model->get($id);

      if (!$marketing_campaign) {
        show_404();
      }
    }
    $data = (array)$marketing_campaign;
    if (!isset($data['id'])) $data['id'] = null;
    if (set_value('id', $data['id'] ?? null)){
        $data['title'] = _l('edit_marketing_campaign');
    }else{
        $data['title'] = _l('new_marketing_campaign');
    }

    $this->load->view('marketing_campaigns/campaign', $data);
  }

  public function remove($id = 0)
  {
    $holiday = $this->holidays_model->get((int)$id);

    if (!$holiday) {
      show_404();
    }

    $success = $this->holidays_model->delete($id);

    if ($success == true) {
      set_alert('success', _l('deleted', _l('hr_holidays')));
    } else {
      set_alert('warning', _l('problem_deleting', _l('hr_holidays')));
    }

    redirect(admin_url('hr/holidays/'));
  }
  public function datatable(){
    if (!has_permission('marketing_campaigns', '', 'view')) {
      access_denied('marketing_campaigns');
    }

    $this->load->model('marketing_campaigns_model');

    $aColumns = [
      'name',
      'start',
      'end',
      'total_budget',

    ];

    $sIndexColumn = 'id';
    $sTable       = db_prefix() . 'marketing_campaigns';

    $where  = [];
    $filter = [];

    if (count($filter) > 0) {
      array_push($where, 'AND (' . prepare_dt_filter($filter) . ')');
    }
    $result  = data_tables_init($aColumns, $sIndexColumn, $sTable, [], $where, ['id']);

    $output  = $result['output'];
    $rResult = $result['rResult'];

    foreach ($rResult as $aRow) {
      $row = [];
      $employee = null;


      $row[]  = $aRow['name'];
      $row[] = date('d-m-Y', strtotime($aRow['start']));
      $row[] = date('d-m-Y', strtotime($aRow['end']));
      $row[]  = round($aRow['total_budget'],2);

      $action
              = '<a type="button" class="btn btn-sm btn-outline-secondary" href="' . admin_url('marketing_campaigns/campaign/' . $aRow['id']) . '"><i class="fal fa-edit"></i></a>';
      $action .= '<a type="button" class="btn btn-sm btn-outline-danger mg-l-5" href="' . admin_url('marketing_campaigns/remove/' . $aRow['id']) . '"><i class="fal fa-trash text-danger"></i></a>';

      $row[]              = $action;
      $output['aaData'][] = $row;
    }

    echo json_encode($output);
    die();
  }

}
